/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.jpa.EntityManagerProvider;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class SelectableEntityManagerProxy
implements EntityManager {
    @Binding(bindingType=BindingType.MUST)
    protected EntityManagerProvider entityManagerProvider;

    protected EntityManager getEntityManager() {
        String prefix = this.entityManagerProvider.getSelectableEntityManagerPrefix();
        if (StringUtil.isEmpty((String)prefix)) {
            throw new EmptyRuntimeException("entityManagerName");
        }
        return this.entityManagerProvider.getEntityManger(prefix);
    }

    public void clear() {
        EntityManager em = this.getEntityManager();
        em.clear();
    }

    public void close() {
        EntityManager em = this.getEntityManager();
        em.close();
    }

    public boolean contains(Object entity) {
        EntityManager em = this.getEntityManager();
        return em.contains(entity);
    }

    public Query createNamedQuery(String name) {
        EntityManager em = this.getEntityManager();
        return em.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        EntityManager em = this.getEntityManager();
        return em.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        EntityManager em = this.getEntityManager();
        return em.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        EntityManager em = this.getEntityManager();
        return em.createNativeQuery(sqlString, resultSetMapping);
    }

    public Query createQuery(String qlString) {
        EntityManager em = this.getEntityManager();
        return em.createQuery(qlString);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        return (T)em.find(entityClass, primaryKey);
    }

    public void flush() {
        EntityManager em = this.getEntityManager();
        em.flush();
    }

    public Object getDelegate() {
        EntityManager em = this.getEntityManager();
        return em.getDelegate();
    }

    public FlushModeType getFlushMode() {
        EntityManager em = this.getEntityManager();
        return em.getFlushMode();
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        return (T)em.getReference(entityClass, primaryKey);
    }

    public EntityTransaction getTransaction() {
        EntityManager em = this.getEntityManager();
        return em.getTransaction();
    }

    public boolean isOpen() {
        EntityManager em = this.getEntityManager();
        return em.isOpen();
    }

    public void joinTransaction() {
        EntityManager em = this.getEntityManager();
        em.joinTransaction();
    }

    public void lock(Object entity, LockModeType lockMode) {
        EntityManager em = this.getEntityManager();
        em.lock(entity, lockMode);
    }

    public <T> T merge(T entity) {
        EntityManager em = this.getEntityManager();
        return (T)em.merge(entity);
    }

    public void persist(Object entity) {
        EntityManager em = this.getEntityManager();
        em.persist(entity);
    }

    public void refresh(Object entity) {
        EntityManager em = this.getEntityManager();
        em.refresh(entity);
    }

    public void remove(Object entity) {
        EntityManager em = this.getEntityManager();
        em.remove(entity);
    }

    public void setFlushMode(FlushModeType flushMode) {
        EntityManager em = this.getEntityManager();
        em.setFlushMode(flushMode);
    }
}

