/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.external.servlet.CookieMap;
import org.seasar.framework.container.external.servlet.HttpSessionMap;
import org.seasar.framework.container.external.servlet.ServletApplicationMap;
import org.seasar.framework.container.external.servlet.ServletInitParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderValuesMap;
import org.seasar.framework.container.external.servlet.ServletRequestMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterValuesMap;

public class HttpServletExternalContext
implements ExternalContext {
    static final Map LAZY_MARK = new HashMap();
    ThreadLocal requests = new ThreadLocal();
    ThreadLocal responses = new ThreadLocal();
    ThreadLocal requestMaps = new ThreadLocal();
    ThreadLocal requestHeaderMaps = new ThreadLocal();
    ThreadLocal requestHeaderValuesMaps = new ThreadLocal();
    ThreadLocal requestParameterMaps = new ThreadLocal();
    ThreadLocal requestParameterValuesMaps = new ThreadLocal();
    ThreadLocal requestCookieMaps = new ThreadLocal();
    ThreadLocal sessionMaps = new ThreadLocal();
    ServletContext application;

    public Object getRequest() {
        return this.getHttpServletRequest();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.requests.get();
    }

    public void setRequest(Object request) {
        this.requests.set(request);
        if (request == null) {
            this.requestMaps.set(new HashMap());
            this.requestHeaderMaps.set(Collections.EMPTY_MAP);
            this.requestHeaderValuesMaps.set(Collections.EMPTY_MAP);
            this.requestCookieMaps.set(Collections.EMPTY_MAP);
            this.requestParameterMaps.set(Collections.EMPTY_MAP);
            this.requestParameterValuesMaps.set(Collections.EMPTY_MAP);
            this.sessionMaps.set(new HashMap());
        } else {
            HttpServletRequest req = (HttpServletRequest)request;
            this.requestMaps.set(new ServletRequestMap((ServletRequest)req));
            this.requestHeaderMaps.set(new ServletRequestHeaderMap(req));
            this.requestHeaderValuesMaps.set(new ServletRequestHeaderValuesMap(req));
            this.requestCookieMaps.set(new CookieMap(req));
            this.requestParameterMaps.set(LAZY_MARK);
            this.requestParameterValuesMaps.set(LAZY_MARK);
            this.sessionMaps.set(LAZY_MARK);
        }
    }

    public Object getResponse() {
        return this.responses.get();
    }

    public void setResponse(Object response) {
        this.responses.set(response);
    }

    public Object getSession() {
        return this.getHttpSession();
    }

    protected HttpSession getHttpSession() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getSession();
    }

    public Object getApplication() {
        return this.application;
    }

    public void setApplication(Object application) {
        if (!(application instanceof ServletContext)) {
            throw new IllegalArgumentException("application:" + application);
        }
        this.application = (ServletContext)application;
    }

    public Map getApplicationMap() {
        return new ServletApplicationMap(this.application);
    }

    public Map getInitParameterMap() {
        return new ServletInitParameterMap(this.application);
    }

    public Map getRequestCookieMap() {
        Map requestCookieMap = (Map)this.requestCookieMaps.get();
        if (requestCookieMap == null) {
            requestCookieMap = Collections.EMPTY_MAP;
            this.requestCookieMaps.set(requestCookieMap);
        }
        return requestCookieMap;
    }

    public Map getRequestHeaderMap() {
        Map requestHeaderMap = (Map)this.requestHeaderMaps.get();
        if (requestHeaderMap == null) {
            requestHeaderMap = Collections.EMPTY_MAP;
            this.requestCookieMaps.set(requestHeaderMap);
        }
        return requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        Map requestHeaderMap = (Map)this.requestHeaderValuesMaps.get();
        if (requestHeaderMap == null) {
            requestHeaderMap = Collections.EMPTY_MAP;
            this.requestHeaderMaps.set(requestHeaderMap);
        }
        return requestHeaderMap;
    }

    public Map getRequestMap() {
        HashMap requestMap = (HashMap)this.requestMaps.get();
        if (requestMap == null) {
            requestMap = new HashMap();
            this.requestMaps.set(requestMap);
        }
        return requestMap;
    }

    public Map getRequestParameterMap() {
        Map requestParameterMap = (Map)this.requestParameterMaps.get();
        if (requestParameterMap == null) {
            requestParameterMap = Collections.EMPTY_MAP;
            this.requestParameterMaps.set(requestParameterMap);
        } else if (requestParameterMap == LAZY_MARK) {
            requestParameterMap = new ServletRequestParameterMap((ServletRequest)this.getHttpServletRequest());
            this.requestParameterMaps.set(requestParameterMap);
        }
        return requestParameterMap;
    }

    public Map getRequestParameterValuesMap() {
        Map requestParameterValuesMap = (Map)this.requestParameterValuesMaps.get();
        if (requestParameterValuesMap == null) {
            requestParameterValuesMap = Collections.EMPTY_MAP;
            this.requestParameterValuesMaps.set(requestParameterValuesMap);
        } else if (requestParameterValuesMap == LAZY_MARK) {
            requestParameterValuesMap = new ServletRequestParameterValuesMap((ServletRequest)this.getHttpServletRequest());
            this.requestParameterValuesMaps.set(requestParameterValuesMap);
        }
        return requestParameterValuesMap;
    }

    public Map getSessionMap() {
        AbstractMap sessionMap = (HashMap)this.sessionMaps.get();
        if (sessionMap == null) {
            sessionMap = new HashMap();
            this.sessionMaps.set(sessionMap);
        } else if (sessionMap == LAZY_MARK) {
            sessionMap = new HttpSessionMap(this.getHttpServletRequest());
            this.sessionMaps.set(sessionMap);
        }
        return sessionMap;
    }
}

