/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.ivy.util.url.URLHandler;

public abstract class AbstractURLHandler
implements URLHandler {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("%25([0-9a-fA-F][0-9a-fA-F])");
    private static int requestMethod = 2;

    protected void validatePutStatusCode(URL dest, int statusCode, String statusMessage) throws IOException {
        switch (statusCode) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                break;
            }
            case 401: 
            case 403: {
                throw new IOException("Access to URL " + dest + " was refused by the server" + (statusMessage == null ? "" : ": " + statusMessage));
            }
            default: {
                throw new IOException("PUT operation to URL " + dest + " failed with status code " + statusCode + (statusMessage == null ? "" : ": " + statusMessage));
            }
        }
    }

    public void setRequestMethod(int requestMethod) {
        AbstractURLHandler.requestMethod = requestMethod;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    protected String normalizeToString(URL url) throws IOException {
        if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
            return url.toExternalForm();
        }
        try {
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            String uriString = uri.toASCIIString();
            uriString = uriString.replaceAll("\\+", "%2B");
            return ESCAPE_PATTERN.matcher(uriString).replaceAll("%$1");
        }
        catch (URISyntaxException e) {
            MalformedURLException ioe = new MalformedURLException("Couldn't convert '" + url.toString() + "' to a valid URI");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected URL normalizeToURL(URL url) throws IOException {
        if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
            return url;
        }
        return new URL(this.normalizeToString(url));
    }
}

