/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

public class Cache2Q
implements Cache {
    public static final String TYPE_NAME = "TQ";
    private static final int MAIN = 1;
    private static final int IN = 2;
    private static final int OUT = 3;
    private static final int PERCENT_IN = 20;
    private static final int PERCENT_OUT = 50;
    private final CacheWriter writer;
    private int maxSize;
    private int maxMain;
    private int maxIn;
    private int maxOut;
    private CacheObject headMain = new CacheHead();
    private CacheObject headIn = new CacheHead();
    private CacheObject headOut = new CacheHead();
    private int sizeMain;
    private int sizeIn;
    private int sizeOut;
    private int recordCount;
    private int len;
    private CacheObject[] values;
    private int mask;

    public Cache2Q(CacheWriter writer, int maxKb) {
        int maxSize = maxKb * 1024 / 4;
        this.writer = writer;
        this.maxSize = maxSize;
        this.len = MathUtils.nextPowerOf2(maxSize / 64);
        this.mask = this.len - 1;
        MathUtils.checkPowerOf2(this.len);
        this.recalculateMax();
        this.clear();
    }

    public void clear() {
        this.headMain.next = this.headMain.previous = this.headMain;
        this.headIn.next = this.headIn.previous = this.headIn;
        this.headOut.next = this.headOut.previous = this.headOut;
        this.values = new CacheObject[this.len];
        this.sizeMain = 0;
        this.sizeOut = 0;
        this.sizeIn = 0;
        this.recordCount = 0;
    }

    private void recalculateMax() {
        this.maxMain = this.maxSize;
        this.maxIn = this.maxSize * 20 / 100;
        this.maxOut = this.maxSize * 50 / 100;
    }

    private void addToFront(CacheObject head, CacheObject rec) {
        if (SysProperties.CHECK) {
            if (rec == head) {
                throw Message.getInternalError("try to move head");
            }
            if (rec.next != null || rec.previous != null) {
                throw Message.getInternalError("already linked");
            }
        }
        rec.next = head;
        rec.previous = head.previous;
        rec.previous.next = rec;
        head.previous = rec;
    }

    private void removeFromList(CacheObject rec) {
        if (SysProperties.CHECK && rec instanceof CacheHead && rec.cacheQueue != 3) {
            throw Message.getInternalError();
        }
        rec.previous.next = rec.next;
        rec.next.previous = rec.previous;
        rec.next = null;
        rec.previous = null;
    }

    public CacheObject get(int pos) {
        CacheObject r = this.findCacheObject(pos);
        if (r == null) {
            return null;
        }
        if (r.cacheQueue == 1) {
            this.removeFromList(r);
            this.addToFront(this.headMain, r);
        } else {
            if (r.cacheQueue == 3) {
                return null;
            }
            if (r.cacheQueue == 2) {
                this.removeFromList(r);
                this.sizeIn -= r.getMemorySize();
                this.sizeMain += r.getMemorySize();
                r.cacheQueue = 1;
                this.addToFront(this.headMain, r);
            }
        }
        return r;
    }

    private CacheObject findCacheObject(int pos) {
        CacheObject rec = this.values[pos & this.mask];
        while (rec != null && rec.getPos() != pos) {
            rec = rec.chained;
        }
        return rec;
    }

    private CacheObject removeCacheObject(int pos) {
        int index = pos & this.mask;
        CacheObject rec = this.values[index];
        if (rec == null) {
            return null;
        }
        if (rec.getPos() == pos) {
            this.values[index] = rec.chained;
        } else {
            do {
                CacheObject last = rec;
                rec = rec.chained;
                if (rec != null) continue;
                return null;
            } while (rec.getPos() != pos);
            last.chained = rec.chained;
        }
        --this.recordCount;
        if (SysProperties.CHECK) {
            rec.chained = null;
        }
        return rec;
    }

    public void remove(int pos) {
        CacheObject r = this.removeCacheObject(pos);
        if (r != null) {
            this.removeFromList(r);
            if (r.cacheQueue == 1) {
                this.sizeMain -= r.getMemorySize();
            } else if (r.cacheQueue == 2) {
                this.sizeIn -= r.getMemorySize();
            }
        }
    }

    private void removeOldIfRequired() throws SQLException {
        if (this.sizeIn >= this.maxIn || this.sizeOut >= this.maxOut || this.sizeMain >= this.maxMain) {
            this.removeOld();
        }
    }

    private void removeOld() throws SQLException {
        int i = 0;
        ObjectArray changed = new ObjectArray();
        while ((this.sizeIn * 4 > this.maxIn * 3 || this.sizeOut * 4 > this.maxOut * 3 || this.sizeMain * 4 > this.maxMain * 3) && this.recordCount > 16) {
            CacheObject r;
            if (++i == this.recordCount) {
                this.writer.flushLog();
            }
            if (i >= this.recordCount * 2) break;
            if (this.sizeIn > this.maxIn) {
                r = this.headIn.next;
                if (!r.canRemove()) {
                    this.removeFromList(r);
                    this.addToFront(this.headIn, r);
                    continue;
                }
                this.sizeIn -= r.getMemorySize();
                int pos = r.getPos();
                this.removeCacheObject(pos);
                this.removeFromList(r);
                if (r.isChanged()) {
                    changed.add(r);
                }
                r = new CacheHead();
                r.setPos(pos);
                r.cacheQueue = 3;
                this.putCacheObject(r);
                this.addToFront(this.headOut, r);
                ++this.sizeOut;
                if (this.sizeOut < this.maxOut) continue;
                r = this.headOut.next;
                --this.sizeOut;
                this.removeCacheObject(r.getPos());
                this.removeFromList(r);
                continue;
            }
            if (this.sizeMain <= 0) continue;
            r = this.headMain.next;
            if (!r.canRemove() && !(r instanceof CacheHead)) {
                this.removeFromList(r);
                this.addToFront(this.headMain, r);
                continue;
            }
            this.sizeMain -= r.getMemorySize();
            this.removeCacheObject(r.getPos());
            this.removeFromList(r);
            if (!r.isChanged()) continue;
            changed.add(r);
        }
        if (changed.size() > 0) {
            CacheObject.sort(changed);
            for (i = 0; i < changed.size(); ++i) {
                CacheObject rec = (CacheObject)changed.get(i);
                this.writer.writeBack(rec);
            }
        }
    }

    public ObjectArray getAllChanged() {
        ObjectArray list = new ObjectArray();
        CacheObject o = this.headMain.next;
        while (o != this.headMain) {
            if (o.isChanged()) {
                list.add(o);
            }
            o = o.next;
        }
        o = this.headIn.next;
        while (o != this.headIn) {
            if (o.isChanged()) {
                list.add(o);
            }
            o = o.next;
        }
        CacheObject.sort(list);
        return list;
    }

    public CacheObject find(int pos) {
        CacheObject o = this.findCacheObject(pos);
        if (o != null && o.cacheQueue != 3) {
            return o;
        }
        return null;
    }

    private void putCacheObject(CacheObject rec) {
        if (SysProperties.CHECK) {
            for (int i = 0; i < rec.getBlockCount(); ++i) {
                CacheObject old = this.find(rec.getPos() + i);
                if (old == null) continue;
                throw Message.getInternalError("try to add a record twice i=" + i);
            }
        }
        int index = rec.getPos() & this.mask;
        rec.chained = this.values[index];
        this.values[index] = rec;
        ++this.recordCount;
    }

    public void put(CacheObject rec) throws SQLException {
        int pos = rec.getPos();
        CacheObject r = this.findCacheObject(pos);
        if (r != null) {
            if (r.cacheQueue == 3) {
                this.removeCacheObject(pos);
                this.removeFromList(r);
                this.removeOldIfRequired();
                rec.cacheQueue = 1;
                this.putCacheObject(rec);
                this.addToFront(this.headMain, rec);
                this.sizeMain += rec.getMemorySize();
            }
        } else if (this.sizeMain < this.maxMain) {
            this.removeOldIfRequired();
            rec.cacheQueue = 1;
            this.putCacheObject(rec);
            this.addToFront(this.headMain, rec);
            this.sizeMain += rec.getMemorySize();
        } else {
            this.removeOldIfRequired();
            rec.cacheQueue = 2;
            this.putCacheObject(rec);
            this.addToFront(this.headIn, rec);
            this.sizeIn += rec.getMemorySize();
        }
    }

    public CacheObject update(int pos, CacheObject rec) throws SQLException {
        CacheObject old = this.find(pos);
        if (old == null || old.cacheQueue == 3) {
            this.put(rec);
        } else if (old == rec && rec.cacheQueue == 1) {
            this.removeFromList(rec);
            this.addToFront(this.headMain, rec);
        }
        return old;
    }

    public void setMaxSize(int maxKb) throws SQLException {
        int newSize = maxKb * 1024 / 4;
        this.maxSize = newSize < 0 ? 0 : newSize;
        this.recalculateMax();
        this.removeOldIfRequired();
    }

    public String getTypeName() {
        return TYPE_NAME;
    }
}

