/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;

public class ExpressionColumn
extends Expression {
    private Database database;
    private String schemaName;
    private String tableAlias;
    private String columnName;
    private ColumnResolver resolver;
    private int queryLevel;
    private Column column;
    private boolean evaluatable;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
    }

    public ExpressionColumn(Database database, String schemaName, String tableAlias, String columnName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableAlias = tableAlias;
        this.columnName = columnName;
    }

    public String getSQL() {
        String sql = this.column != null ? this.column.getSQL() : this.columnName;
        if (this.tableAlias != null) {
            sql = Parser.quoteIdentifier(this.tableAlias) + "." + sql;
        }
        if (this.schemaName != null) {
            sql = Parser.quoteIdentifier(this.schemaName) + "." + sql;
        }
        return sql;
    }

    public TableFilter getTableFilter() {
        return this.resolver == null ? null : this.resolver.getTableFilter();
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        Column col;
        int i;
        if (this.tableAlias != null && !this.tableAlias.equals(resolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.schemaName.equals(resolver.getSchemaName())) {
            return;
        }
        Column[] columns = resolver.getColumns();
        for (i = 0; i < columns.length; ++i) {
            col = columns[i];
            if (!this.columnName.equals(col.getName())) continue;
            this.mapColumn(resolver, col, level);
            return;
        }
        columns = resolver.getSystemColumns();
        for (i = 0; columns != null && i < columns.length; ++i) {
            col = columns[i];
            if (!this.columnName.equals(col.getName())) continue;
            this.mapColumn(resolver, col, level);
            return;
        }
    }

    private void mapColumn(ColumnResolver resolver, Column col, int level) throws SQLException {
        if (this.resolver == null) {
            this.queryLevel = level;
            this.column = col;
            this.resolver = resolver;
        } else if (this.queryLevel == level && this.resolver != resolver) {
            throw Message.getSQLException(90059, this.columnName);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        if (this.resolver == null) {
            Constant constant;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (constant = schema.findConstant(this.columnName)) != null) {
                return constant.getValue();
            }
            String name = this.columnName;
            if (this.tableAlias != null) {
                name = this.tableAlias + "." + name;
                if (this.schemaName != null) {
                    name = this.schemaName + "." + name;
                }
            }
            throw Message.getSQLException(42122, name);
        }
        return this;
    }

    public void updateAggregate(Session session) throws SQLException {
        Value now = this.resolver.getValue(this.column);
        Select select = this.resolver.getSelect();
        if (select == null) {
            throw Message.getSQLException(90016, this.getSQL());
        }
        HashMap values = select.getCurrentGroup();
        if (values == null) {
            return;
        }
        Value v = (Value)values.get(this);
        if (v == null) {
            values.put(this, now);
        } else if (!this.database.areEqual(now, v)) {
            throw Message.getSQLException(90016, this.getSQL());
        }
    }

    public Value getValue(Session session) throws SQLException {
        Value v;
        HashMap values;
        Select select = this.resolver.getSelect();
        if (select != null && (values = select.getCurrentGroup()) != null && (v = (Value)values.get(this)) != null) {
            return v;
        }
        Value value = this.resolver.getValue(this.column);
        if (value == null) {
            throw Message.getSQLException(90016, this.getSQL());
        }
        return value;
    }

    public int getType() {
        return this.column.getType();
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.resolver != null && tableFilter == this.resolver.getTableFilter()) {
            this.evaluatable = b;
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public int getScale() {
        return this.column.getScale();
    }

    public long getPrecision() {
        return this.column.getPrecision();
    }

    public int getDisplaySize() {
        return this.column.getDisplaySize();
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalAliasName() {
        return this.tableAlias;
    }

    public String getColumnName() {
        return this.columnName != null ? this.columnName : this.column.getName();
    }

    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    public String getAlias() {
        return this.column.getName();
    }

    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }

    public int getNullable() {
        return this.column.getNullable() ? 1 : 0;
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.type) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: {
                return true;
            }
            case 0: {
                return this.queryLevel < visitor.queryLevel;
            }
            case 3: {
                return this.evaluatable || visitor.queryLevel < this.queryLevel;
            }
            case 4: {
                visitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.resolver != visitor.getResolver();
            }
            case 7: {
                visitor.addDependency(this.column.getTable());
                return true;
            }
        }
        throw Message.getInternalError("type=" + visitor.type);
    }

    public int getCost() {
        return 2;
    }

    public void createIndexConditions(Session session, TableFilter filter) {
        TableFilter tf = this.getTableFilter();
        if (filter == tf && this.column.getType() == 1) {
            IndexCondition cond = new IndexCondition(0, this, ValueExpression.get(ValueBoolean.get(true)));
            filter.addIndexCondition(cond);
        }
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }
}

