/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers$Caller;
import org.apache.ivy.core.resolve.IvyNodeEviction$EvictionData;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager$IvyNodeArtifactInfo;
import org.apache.ivy.plugins.conflict.LatestConflictManager$NoConflictResolvedYetException;
import org.apache.ivy.plugins.conflict.StrictConflictException;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public final class LatestCompatibleConflictManager
extends LatestConflictManager {
    public LatestCompatibleConflictManager() {
    }

    public LatestCompatibleConflictManager(String string, LatestStrategy latestStrategy) {
        super(string, latestStrategy);
    }

    public final Collection resolveConflicts(IvyNode ivyNode, Collection collection) {
        Iterator iterator;
        IvyNode ivyNode2;
        ModuleRevisionId moduleRevisionId;
        if (collection.size() < 2) {
            return collection;
        }
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        if (versionMatcher.isDynamic(moduleRevisionId = (ivyNode2 = (IvyNode)(iterator = collection.iterator()).next()).getResolvedId())) {
            Object object;
            while (iterator.hasNext()) {
                object = (IvyNode)iterator.next();
                if (versionMatcher.isDynamic(((IvyNode)object).getResolvedId())) {
                    return null;
                }
                if (versionMatcher.accept(moduleRevisionId, ((IvyNode)object).getResolvedId()) || this.handleIncompatibleConflict$35c3fbed(ivyNode, ivyNode2, (IvyNode)object)) continue;
                return null;
            }
            if (collection.size() == 2) {
                object = collection.iterator();
                object.next();
                return Collections.singleton(object.next());
            }
            object = new LinkedHashSet(collection);
            object.remove(ivyNode2);
            return super.resolveConflicts(ivyNode, (Collection)object);
        }
        while (iterator.hasNext()) {
            IvyNode ivyNode3 = (IvyNode)iterator.next();
            if (versionMatcher.accept(ivyNode3.getResolvedId(), moduleRevisionId) || this.handleIncompatibleConflict$35c3fbed(ivyNode, ivyNode2, ivyNode3)) continue;
            return null;
        }
        return Collections.singleton(ivyNode2);
    }

    private boolean handleIncompatibleConflict$35c3fbed(IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3) {
        try {
            LatestConflictManager$IvyNodeArtifactInfo latestConflictManager$IvyNodeArtifactInfo = (LatestConflictManager$IvyNodeArtifactInfo)this.getStrategy().findLatest(LatestCompatibleConflictManager.toArtifactInfo(Arrays.asList(ivyNode2, ivyNode3)), null);
            if (latestConflictManager$IvyNodeArtifactInfo != null) {
                IvyNode ivyNode4 = latestConflictManager$IvyNodeArtifactInfo.getNode();
                IvyNode ivyNode5 = ivyNode4 == ivyNode2 ? ivyNode3 : ivyNode2;
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), ivyNode, ivyNode5, ivyNode4);
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), ivyNode, ivyNode4, ivyNode5);
                LatestCompatibleConflictManager.handleUnsolvableConflict$35c3fbe9(ivyNode2, ivyNode3);
                return true;
            }
            return false;
        }
        catch (LatestConflictManager$NoConflictResolvedYetException latestConflictManager$NoConflictResolvedYetException) {
            return false;
        }
    }

    private void blackListIncompatibleCallerAndRestartResolveIfPossible(IvySettings ivySettings, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3) {
        Stack<IvyNode> stack = new Stack<IvyNode>();
        stack.push(ivyNode3);
        Collection collection = this.blackListIncompatibleCaller(ivySettings.getVersionMatcher(), ivyNode, ivyNode2, ivyNode3, stack);
        if (collection != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Object object = collection.iterator();
            while (object.hasNext()) {
                IvyNodeBlacklist ivyNodeBlacklist = (IvyNodeBlacklist)object.next();
                ivyNodeBlacklist.getBlacklistedNode().blacklist(ivyNodeBlacklist);
                stringBuffer.append(ivyNodeBlacklist.getBlacklistedNode());
                if (!object.hasNext()) continue;
                stringBuffer.append(" ");
            }
            object = ivyNode.getData().getReport().getConfiguration();
            ivyNode3.markEvicted(new IvyNodeEviction$EvictionData((String)object, ivyNode, this, Collections.singleton(ivyNode2), "with blacklisting of " + stringBuffer));
            if (ivySettings.debugConflictResolution()) {
                Message.debug("evicting " + ivyNode3 + " by " + ivyNode3.getEvictedData((String)object));
            }
            throw new RestartResolveProcess("trying to handle incompatibilities between " + ivyNode2 + " and " + ivyNode3);
        }
    }

    private Collection blackListIncompatibleCaller(VersionMatcher versionMatcher, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3, Stack stack) {
        ArrayList<IvyNodeBlacklist> arrayList = new ArrayList<IvyNodeBlacklist>();
        IvyNode ivyNode4 = (IvyNode)stack.peek();
        String string = ivyNode.getData().getReport().getConfiguration();
        IvyNodeCallers$Caller[] ivyNodeCallers$CallerArray = ivyNode4.getCallers(string);
        for (int i = 0; i < ivyNodeCallers$CallerArray.length; ++i) {
            IvyNode ivyNode5 = ivyNode4.findNode(ivyNodeCallers$CallerArray[i].getModuleRevisionId());
            if (ivyNode5.isBlacklisted(string)) continue;
            if (versionMatcher.isDynamic(ivyNodeCallers$CallerArray[i].getAskedDependencyId$53b7e4ab())) {
                arrayList.add(new IvyNodeBlacklist(ivyNode, ivyNode2, ivyNode3, ivyNode4, string));
                continue;
            }
            if (stack.subList(0, stack.size() - 1).contains(ivyNode4)) continue;
            if (ivyNode5 == null) {
                return null;
            }
            stack.push(ivyNode5);
            Collection collection = this.blackListIncompatibleCaller(versionMatcher, ivyNode, ivyNode2, ivyNode3, stack);
            stack.pop();
            if (collection == null) {
                return null;
            }
            arrayList.addAll(collection);
        }
        if (arrayList.isEmpty() && !stack.subList(0, stack.size() - 1).contains(ivyNode4)) {
            return null;
        }
        return arrayList;
    }

    private static void handleUnsolvableConflict$35c3fbe9(IvyNode ivyNode, IvyNode ivyNode2) {
        throw new StrictConflictException(ivyNode, ivyNode2);
    }

    public final void handleAllBlacklistedRevisions$5b957239(Collection collection) {
        ResolveData resolveData = IvyContext.getContext().getResolveData();
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleRevisionId moduleRevisionId = (ModuleRevisionId)iterator.next();
            hashSet.add(resolveData.getNode(moduleRevisionId));
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IvyNodeBlacklist ivyNodeBlacklist = ((IvyNode)iterator.next()).getBlacklistData(resolveData.getReport().getConfiguration());
            Arrays.asList(ivyNodeBlacklist.getEvictedNode(), ivyNodeBlacklist.getSelectedNode());
            LatestCompatibleConflictManager.handleUnsolvableConflict$35c3fbe9(ivyNodeBlacklist.getEvictedNode(), ivyNodeBlacklist.getSelectedNode());
        }
    }

    public final String toString() {
        return this.getName();
    }
}

