/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.seasar.framework.exception.SAXRuntimeException;
import org.seasar.framework.util.SchemaFactoryUtil;
import org.xml.sax.SAXException;

public abstract class SchemaUtil {
    public static Schema newW3cXmlSchema(File schema) {
        return SchemaUtil.newSchema(SchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newW3cXmlSchema(Source schema) {
        return SchemaUtil.newSchema(SchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newW3cXmlSchema(URL schema) {
        return SchemaUtil.newSchema(SchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(File schema) {
        return SchemaUtil.newSchema(SchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(Source schema) {
        return SchemaUtil.newSchema(SchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(URL schema) {
        return SchemaUtil.newSchema(SchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newSchema(SchemaFactory factory, File schema) {
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static Schema newSchema(SchemaFactory factory, Source schema) {
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static Schema newSchema(SchemaFactory factory, URL schema) {
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }
}

