package jp.sf.amateras.rdiffbackup.util;

import java.io.File;

import org.seasar.struts.util.RequestUtil;

/**
 * ファイルの種類に応じたアイコンを取得するためのユーティリティです。
 *
 * @author Naoki Takezoe
 */
public class IconManager {

	/**
	 * ファイルの種類に応じたアイコンのパスを返却します。
	 *
	 * @param file ファイル
	 * @return アイコンのパス
	 */
	public static String getIcon(File file){
		if(file.isDirectory()){
			return getIconPath("folder.png");
		}

		String name = file.getName();

		if(name.endsWith(".xls") || name.endsWith(".xlsx")){
			return getIconPath("page_white_excel.png");
		}
		if(name.endsWith(".doc") || name.endsWith(".docx")){
			return getIconPath("page_white_word.png");
		}
		if(name.endsWith(".ppt") || name.endsWith(".pptx")){
			return getIconPath("page_white_powerpoint.png");
		}
		if(name.endsWith(".java")){
			return getIconPath("page_white_cup.png");
		}
		if(name.endsWith(".c")){
			return getIconPath("page_white_c.png");
		}
		if(name.endsWith(".cpp")){
			return getIconPath("page_white_cplusplus.png");
		}
		if(name.endsWith(".h")){
			return getIconPath("page_white_h.png");
		}
		if(name.endsWith(".php")){
			return getIconPath("page_white_php.png");
		}
		if(name.endsWith(".exe") || name.endsWith(".bat") || name.endsWith(".sh")){
			return getIconPath("page_white_gear.png");
		}
		if(name.endsWith(".cs")){
			return getIconPath("page_white_csharp.png");
		}
		if(name.endsWith(".html")){
			return getIconPath("page_white_world.png");
		}
//		if(name.endsWith(".css")){
//			return getIconPath("page_white_code.png");
//		}
		if(name.endsWith(".zip") || name.endsWith(".lzh") || name.endsWith(".gz") || name.endsWith(".tar")){
			return getIconPath("package.png");
		}
		if(name.endsWith(".pdf")){
			return getIconPath("page_white_acrobat.png");
		}

		return getIconPath("page_white.png");
	}

	private static String getIconPath(String icon){
		return RequestUtil.getRequest().getContextPath() + "/images/" + icon;
	}

}
