package code
package util

import org.specs._
import java.io.File
import java.lang.IllegalArgumentException

class UtilTestSpec extends Specification {

  "isNullOrEmpty" should {
    "return true for null" in {
      Util.isNullOrEmpty(null) must be (true)
    }
    "return true for empty string" in {
      Util.isNullOrEmpty("") must be (true)
    }
    "return false for whitespace" in {
      Util.isNullOrEmpty(" ") must be (false)
    }
  }

  "getParentPath" should {
    "return the parent path for the directory" in {
      Util.getParentPath("aaa/bbb/ccc/") mustEqual "aaa/bbb"
    }
    "return the parent path for the file" in {
      Util.getParentPath("aaa/bbb/ccc.txt") mustEqual "aaa/bbb"
    }
  }

  "checkPath" should {
    "not throw IllegalArgumentException if given path does not contain '..'" in {
      Util.checkPath("aaa/bbb/") mustNot throwA(new IllegalArgumentException())
    }
    "throw IllegalArgumentException if given path contauns '..' " in {
      Util.checkPath("../bbb/") must throwA(new IllegalArgumentException())
    }
  }
  
  "u" should {
    "encode as UTF-8" in {
      Util.u("こんにちは") mustEqual "%E3%81%93%E3%82%93%E3%81%AB%E3%81%A1%E3%81%AF"
    }
  }

  "getIcon()" should {
    "return '/images/folder.png' for a folder" in {
      val icon = Util.getIcon(new File("src"))
      icon mustEqual "/images/folder.png"
    }
    "return '/images/page_white_word.png' for a MS Word document" in {
      val icon = Util.getIcon(new File("hoge.docx"))
      icon mustEqual "/images/page_white_word.png"
    }
  }
}
