import sbt._

class LiftProject(info: ProjectInfo) extends DefaultWebProject(info) {
  val liftVersion = "2.3"

  // uncomment the following if you want to use the snapshot repo
  //  val scalatoolsSnapshot = ScalaToolsSnapshots

  // If you're using JRebel for Lift development, uncomment
  // this line
  // override def scanDirectories = Nil

  override def libraryDependencies = Set(
    "net.liftweb" %% "lift-webkit" % liftVersion % "compile",
    "net.liftweb" %% "lift-mapper" % liftVersion % "compile",
    "org.mortbay.jetty" % "jetty" % "6.1.22" % "test",
    "junit" % "junit" % "4.5" % "test",
    "ch.qos.logback" % "logback-classic" % "0.9.26",
    "com.google.guava" % "guava" % "r09",
    "org.apache.commons" % "commons-compress" % "1.1",
    "javax.servlet" % "servlet-api" % "2.4" % "provided",
    "org.scala-tools.testing" %% "specs" % "1.6.6" % "test"
  ) ++ super.libraryDependencies


  override def javaCompileOptions = super.javaCompileOptions ++
    Seq("-source", "1.5","-encoding", "utf8").map(x => JavaCompileOption(x))

  override def artifactBaseName: String = projectName.get.get

}
