package jp.sf.amateras.mirage.tool;

import static org.mockito.Mockito.*;

import java.sql.Connection;
import java.sql.DriverManager;

import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.annotation.PrimaryKey.GenerationType;
import jp.sf.amateras.mirage.dialect.HyperSQLDialect;
import jp.sf.amateras.mirage.dialect.StandardDialect;
import jp.sf.amateras.mirage.naming.DefaultNameConverter;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.util.IOUtil;
import junit.framework.TestCase;

public class EntityGenTest extends TestCase {

	private static final String SQL_PREFIX = "jp/sf/amateras/mirage/";

	private SqlManager sqlManager = new SqlManagerImpl();
	private Connection conn;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		Class.forName("org.hsqldb.jdbc.JDBCDriver");
		conn = DriverManager.getConnection("jdbc:hsqldb:mem:mirage_test", "sa", "");

		ConnectionProvider connectionProvider = mock(ConnectionProvider.class);
		when(connectionProvider.getConnection()).thenReturn(conn);

		sqlManager.setConnectionProvider(connectionProvider);
		sqlManager.setDialect(new HyperSQLDialect());
		executeMultipleStatement(SQL_PREFIX + "SqlManagerImplTest_setUp.sql");
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		executeMultipleStatement(SQL_PREFIX + "SqlManagerImplTest_tearDown.sql");
		conn.close();
	}

	private void executeMultipleStatement(String sqlPath) throws Exception {
		ClassLoader cl = Thread.currentThread().getContextClassLoader();
		byte[] bytes = IOUtil.readStream(cl.getResourceAsStream(sqlPath));
		String sql = new String(bytes, "UTF-8");
		for(String statement: sql.split(";")){
			if(statement.trim().length() > 0){
				sqlManager.executeUpdateBySql(statement);
			}
		}
	}

	public void testGetEntitySource() throws Exception {
		EntityGen gen = new EntityGen();
		gen.setPackageName("jp.sf.amateras.mirage.entity");
		gen.setNameConverter(new DefaultNameConverter());
		gen.setGenerationType(GenerationType.SEQUENCE);
		gen.setDialect(new StandardDialect());

		String result = gen.getEntitySource(conn, "BOOK", null, null);

		String expect = new String(IOUtil.readStream(
				EntityGenTest.class.getResourceAsStream("EntityGenTest_testGetEntitySource.txt")),
				"UTF-8");

		assertEquals(expect, result);
	}

}
