package jp.sf.amateras.mirage;

import java.util.List;

import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.provider.ConnectionProvider;

public interface SqlManager {

	public void setNameConverter(NameConverter converter);

	public void setConnectionProvider(ConnectionProvider connectionProvider);

	public <T> List<T> getResultList(Class<T> clazz, String sqlPath);

	public <T> List<T> getResultList(Class<T> clazz, String sqlPath, Object param);

	public <T> T getSingleResult(Class<T> clazz, String sqlPath);

	public <T> T getSingleResult(Class<T> clazz, String sqlPath, Object param);

	public int executeUpdate(String sqlPath);

	public int executeUpdate(String sqlPath, Object param);

	public int insertEntity(Object entity);

	public int updateEntity(Object entity);

	public int deleteEntity(Object entity);

}
