package jp.sf.amateras.functions;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import javax.servlet.http.HttpServletRequest;

import jp.sf.amateras.functions.utils.RequestUtils;
import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class Log4jTest extends TestCase {

	@Mock
	private HttpServletRequest request;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		MockitoAnnotations.initMocks(this);
		RequestUtils.setRequest(request);
	}
	
	protected void tearDown() throws Exception {
		super.tearDown();
		RequestUtils.removeRequest();
	}
	
	public void testGetLoggerName() {
		assertEquals("jsp.index", Log4j.getLoggerName("/index.jsp"));
		assertEquals("jsp.admin.index", Log4j.getLoggerName("/admin/index.jsp"));
		assertEquals("index", Log4j.getLoggerName("/index"));
		assertEquals("index.do", Log4j.getLoggerName("/index.do"));
	}
	
	public void testGetLogger_1(){
		when(request.getServletPath()).thenReturn("/index.jsp");
		
		Logger logger = Log4j.getLogger();
		assertEquals("jsp.index", logger.getName());
		
		verify(request).getServletPath();
	}

	public void testGetLogger_2(){
		when(request.getServletPath()).thenReturn("/admin/index.jsp");
		
		Logger logger = Log4j.getLogger();
		assertEquals("jsp.admin.index", logger.getName());
		
		verify(request).getServletPath();
	}
}
