/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;

public class InterruptStatus {
    private static final ThreadLocal exception = new ThreadLocal();

    public static void setInterrupted() {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        Thread.interrupted();
        StandardException standardException = StandardException.newException("08000");
        if (languageConnectionContext != null) {
            languageConnectionContext.setInterruptedException(standardException);
        } else {
            exception.set(standardException);
        }
    }

    public static boolean noteAndClearInterrupt(String string, int n, int n2) {
        if (Thread.currentThread().isInterrupted()) {
            InterruptStatus.setInterrupted();
            Thread.interrupted();
            return true;
        }
        return false;
    }

    public static void restoreIntrFlagIfSeen() {
        LanguageConnectionContext languageConnectionContext = null;
        try {
            languageConnectionContext = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        if (languageConnectionContext == null) {
            if (exception.get() != null) {
                exception.set(null);
                Thread.currentThread().interrupt();
            }
        } else if (languageConnectionContext.getInterruptedException() != null) {
            languageConnectionContext.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void restoreIntrFlagIfSeen(LanguageConnectionContext languageConnectionContext) {
        if (languageConnectionContext.getInterruptedException() != null) {
            languageConnectionContext.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void throwIf(LanguageConnectionContext languageConnectionContext) throws StandardException {
        StandardException standardException = languageConnectionContext.getInterruptedException();
        if (standardException != null) {
            languageConnectionContext.setInterruptedException(null);
            Thread.currentThread().interrupt();
            throw standardException;
        }
    }
}

