/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;

public final class IvyAuthenticator
extends Authenticator {
    public static final IvyAuthenticator INSTANCE = new IvyAuthenticator();

    private IvyAuthenticator() {
        Authenticator.setDefault(this);
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication result = null;
        String proxyHost = System.getProperty("http.proxyHost");
        if (this.getRequestingHost().equals(proxyHost)) {
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null && proxyUser.trim().length() > 0) {
                String proxyPass = System.getProperty("http.proxyPassword", "");
                Message.debug("authenicating to proxy server with username [" + proxyUser + "]");
                result = new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
            }
        } else {
            Credentials c = CredentialsStore.INSTANCE.getCredentials(this.getRequestingPrompt(), this.getRequestingHost());
            Message.debug("authentication: k='" + Credentials.buildKey(this.getRequestingPrompt(), this.getRequestingHost()) + "' c='" + c + "'");
            if (c != null) {
                result = new PasswordAuthentication(c.getUserName(), c.getPasswd().toCharArray());
            }
        }
        return result;
    }
}

