/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public class ModuleRevisionId
extends UnmodifiableExtendableItem {
    private static final Map CACHE = new WeakHashMap();
    public static final Pattern MRID_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)(?:#([a-zA-Z0-9\\-/\\._+=]+))?;([a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    public static final Pattern NON_CAPTURING_PATTERN = Pattern.compile("(?:[a-zA-Z0-9\\-/\\._+=]*)#(?:[a-zA-Z0-9\\-/\\._+=]+)(?:#(?:[a-zA-Z0-9\\-/\\._+=]+))?;(?:[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    private final ModuleId moduleId;
    private final String branch;
    private final String revision;
    private int hash;

    public static ModuleRevisionId newInstance(String organisation, String name, String revision) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), revision));
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String branch, String revision, Map extraAttributes) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), branch, revision, extraAttributes));
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String branch, String revision, Map extraAttributes, boolean replaceNullBranchWithDefault) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), branch, revision, extraAttributes, replaceNullBranchWithDefault));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId mrid, String rev) {
        return ModuleRevisionId.intern(new ModuleRevisionId(mrid.getModuleId(), mrid.getBranch(), rev, mrid.getQualifiedExtraAttributes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleRevisionId intern(ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId r = null;
        Map map = CACHE;
        synchronized (map) {
            WeakReference ref = (WeakReference)CACHE.get(moduleRevisionId);
            if (ref != null) {
                r = (ModuleRevisionId)ref.get();
            }
            if (r == null) {
                r = moduleRevisionId;
                CACHE.put(r, new WeakReference<ModuleRevisionId>(r));
            }
        }
        return r;
    }

    public ModuleRevisionId(ModuleId moduleId, String revision) {
        this(moduleId, null, revision, null);
    }

    private ModuleRevisionId(ModuleId moduleId, String branch, String revision, Map extraAttributes) {
        this(moduleId, branch, revision, extraAttributes, true);
    }

    private ModuleRevisionId(ModuleId moduleId, String branch, String revision, Map extraAttributes, boolean replaceNullBranchWithDefault) {
        super(null, extraAttributes);
        this.moduleId = moduleId;
        IvyContext context = IvyContext.getContext();
        this.branch = replaceNullBranchWithDefault && branch == null ? (context.peekIvy() == null ? null : context.getSettings().getDefaultBranch(moduleId)) : branch;
        this.revision = revision == null ? Ivy.getWorkingRevision() : revision;
        this.setStandardAttribute("organisation", this.moduleId.getOrganisation());
        this.setStandardAttribute("module", this.moduleId.getName());
        this.setStandardAttribute("branch", this.branch);
        this.setStandardAttribute("revision", this.revision);
    }

    public ModuleId getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.getModuleId().getName();
    }

    public String getOrganisation() {
        return this.getModuleId().getOrganisation();
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleRevisionId)) {
            return false;
        }
        ModuleRevisionId other = (ModuleRevisionId)obj;
        if (!other.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (other.getBranch() == null && this.getBranch() != null) {
            return false;
        }
        if (other.getBranch() != null && !other.getBranch().equals(this.getBranch())) {
            return false;
        }
        if (!other.getModuleId().equals(this.getModuleId())) {
            return false;
        }
        return ((Object)other.getQualifiedExtraAttributes()).equals(this.getQualifiedExtraAttributes());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.getBranch() == null ? 0 : this.getBranch().hashCode());
            this.hash = this.hash * 13 + this.getRevision().hashCode();
            this.hash = this.hash * 13 + this.getModuleId().hashCode();
            this.hash = this.hash * 13 + ((Object)this.getQualifiedExtraAttributes()).hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.moduleId + (this.branch == null || this.branch.length() == 0 ? "" : "#" + this.branch) + ";" + (this.revision == null ? "NONE" : this.revision);
    }

    public String encodeToString() {
        StringBuffer buf = new StringBuffer();
        Map attributes = this.getAttributes();
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String attName = (String)iter.next();
            String value = (String)attributes.get(attName);
            value = value == null ? "@#:NULL:#@" : value;
            buf.append("+").append(attName).append(":#@#:").append("+").append(value).append(":#@#:");
        }
        return buf.toString();
    }

    public String getBranch() {
        return this.branch;
    }
}

