/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.portlet;

import java.util.Iterator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.seasar.framework.container.external.AbstractExternalContextMap;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.EmptyIterator;
import org.seasar.framework.util.EnumerationIterator;

public class PortletSessionMap
extends AbstractExternalContextMap {
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private PortletRequest request;

    public PortletSessionMap(PortletRequest request) {
        AssertionUtil.assertNotNull("request is null.", request);
        this.request = request;
    }

    protected Object getAttribute(String key) {
        PortletSession session = this.getSession();
        return session != null ? session.getAttribute(key) : null;
    }

    protected void setAttribute(String key, Object value) {
        this.request.getPortletSession(true).setAttribute(key, value);
    }

    protected Iterator getAttributeNames() {
        PortletSession session = this.getSession();
        return session != null ? new EnumerationIterator(session.getAttributeNames()) : EMPTY_ITERATOR;
    }

    protected void removeAttribute(String key) {
        PortletSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(key);
        }
    }

    private PortletSession getSession() {
        return this.request.getPortletSession(false);
    }
}

