/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory.property;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.seasar.framework.container.AccessTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.property.AbstractPropertyDefBuilder;
import org.seasar.framework.container.impl.AbstractExpression;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.jpa.PersistenceUnitManager;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitPropertyDefBuilder
extends AbstractPropertyDefBuilder<PersistenceUnit> {
    @Override
    protected Class<PersistenceUnit> getAnnotationType() {
        return PersistenceUnit.class;
    }

    @Override
    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef, PersistenceUnit persistenceUnit) {
        String name = persistenceUnit.name();
        if (!StringUtil.isEmpty((String)name)) {
            return this.createPropertyDef(propertyName, accessTypeDef, name);
        }
        String unitName = persistenceUnit.unitName();
        if (StringUtil.isEmpty((String)unitName)) {
            return this.createPropertyDef(propertyName, accessTypeDef);
        }
        return this.createPropertyDef(propertyName, accessTypeDef, PersistenceUnitPropertyDefBuilder.createPersistenceUnitComponentDef(unitName));
    }

    protected static ComponentDef createPersistenceUnitComponentDef(String unitName) {
        ComponentDefImpl componentDef = new ComponentDefImpl(EntityManagerFactory.class);
        componentDef.setExpression(PersistenceUnitPropertyDefBuilder.getExpression(unitName));
        componentDef.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl("close"));
        return componentDef;
    }

    protected static Expression getExpression(String unitName) {
        return new PersistenceUnitExpression(unitName);
    }

    public static class PersistenceUnitExpression
    extends AbstractExpression {
        String unitName;

        public PersistenceUnitExpression(String unitName) {
            super(unitName);
            this.unitName = unitName;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public Object evaluate(S2Container container, Map context) {
            PersistenceUnitManager pum = (PersistenceUnitManager)container.getComponent((Object)"jpa.persistenceUnitManager");
            return pum.getEntityManagerFactory(this.unitName);
        }
    }
}

