/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public class ValueEvalToNumericXlator {
    public static final int STRING_IS_PARSED = 1;
    public static final int BOOL_IS_PARSED = 2;
    public static final int BLANK_IS_PARSED = 4;
    public static final int REF_STRING_IS_PARSED = 8;
    public static final int REF_BOOL_IS_PARSED = 16;
    public static final int REF_BLANK_IS_PARSED = 32;
    public static final int EVALUATED_REF_STRING_IS_PARSED = 64;
    public static final int EVALUATED_REF_BOOL_IS_PARSED = 128;
    public static final int EVALUATED_REF_BLANK_IS_PARSED = 256;
    public static final int STRING_TO_BOOL_IS_PARSED = 512;
    public static final int REF_STRING_TO_BOOL_IS_PARSED = 1024;
    public static final int STRING_IS_INVALID_VALUE = 2048;
    public static final int REF_STRING_IS_INVALID_VALUE = 4096;
    private final int flags;

    public ValueEvalToNumericXlator(int flags) {
        this.flags = flags;
    }

    public ValueEval attemptXlateToNumeric(ValueEval eval) {
        ValueEval retval = null;
        if (eval == null) {
            retval = BlankEval.INSTANCE;
        } else if (eval instanceof NumberEval) {
            retval = (NumberEval)eval;
        } else if (eval instanceof BoolEval) {
            retval = (this.flags & 2) > 0 ? (NumericValueEval)eval : this.xlateBlankEval(4);
        } else if (eval instanceof StringEval) {
            retval = this.xlateStringEval((StringEval)eval);
        } else if (eval instanceof RefEval) {
            retval = this.xlateRefEval((RefEval)eval);
        } else if (eval instanceof ErrorEval) {
            retval = eval;
        } else if (eval instanceof BlankEval) {
            retval = this.xlateBlankEval(4);
        } else {
            throw new RuntimeException("Invalid ValueEval type passed for conversion: " + eval.getClass());
        }
        return retval;
    }

    private ValueEval xlateBlankEval(int flag) {
        return (this.flags & flag) > 0 ? NumberEval.ZERO : BlankEval.INSTANCE;
    }

    private ValueEval xlateRefEval(RefEval reval) {
        ValueEval retval = null;
        ValueEval eval = reval.getInnerValueEval();
        if (eval instanceof NumberEval) {
            retval = (NumberEval)eval;
        } else if (eval instanceof BoolEval) {
            retval = (this.flags & 0x10) > 0 ? eval : BlankEval.INSTANCE;
        } else if (eval instanceof StringEval) {
            retval = this.xlateRefStringEval((StringEval)eval);
        } else if (eval instanceof ErrorEval) {
            retval = eval;
        } else if (eval instanceof RefEval) {
            RefEval re = (RefEval)eval;
            retval = this.xlateRefEval(re);
        } else if (eval instanceof BlankEval) {
            retval = this.xlateBlankEval(reval.isEvaluated() ? 256 : 32);
        } else {
            throw new RuntimeException("Invalid ValueEval type passed for conversion: " + eval.getClass());
        }
        return retval;
    }

    private ValueEval xlateStringEval(StringEval eval) {
        ValueEval retval;
        block11: {
            retval = null;
            if ((this.flags & 1) > 0) {
                String s = eval.getStringValue();
                try {
                    double d = Double.parseDouble(s);
                    retval = new NumberEval(d);
                }
                catch (Exception e) {
                    if ((this.flags & 0x200) > 0) {
                        try {
                            boolean b = Boolean.getBoolean(s);
                            retval = b ? BoolEval.TRUE : BoolEval.FALSE;
                        }
                        catch (Exception e2) {
                            retval = ErrorEval.VALUE_INVALID;
                        }
                        break block11;
                    }
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else if ((this.flags & 0x200) > 0) {
                String s = eval.getStringValue();
                try {
                    boolean b = Boolean.getBoolean(s);
                    retval = b ? BoolEval.TRUE : BoolEval.FALSE;
                }
                catch (Exception e) {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else {
                retval = (this.flags & 0x800) > 0 ? ErrorEval.VALUE_INVALID : this.xlateBlankEval(4);
            }
        }
        return retval;
    }

    private ValueEval xlateRefStringEval(StringEval eval) {
        ValueEval retval;
        block11: {
            retval = null;
            if ((this.flags & 8) > 0) {
                StringEval sve = eval;
                String s = sve.getStringValue();
                try {
                    double d = Double.parseDouble(s);
                    retval = new NumberEval(d);
                }
                catch (Exception e) {
                    if ((this.flags & 0x400) > 0) {
                        try {
                            boolean b = Boolean.getBoolean(s);
                            retval = b ? BoolEval.TRUE : BoolEval.FALSE;
                        }
                        catch (Exception e2) {
                            retval = ErrorEval.VALUE_INVALID;
                        }
                        break block11;
                    }
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else if ((this.flags & 0x400) > 0) {
                StringEval sve = eval;
                String s = sve.getStringValue();
                try {
                    boolean b = Boolean.getBoolean(s);
                    retval = b ? BoolEval.TRUE : BoolEval.FALSE;
                }
                catch (Exception e) {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else {
                retval = (this.flags & 0x1000) > 0 ? ErrorEval.VALUE_INVALID : BlankEval.INSTANCE;
            }
        }
        return retval;
    }
}

