/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;

public abstract class XYNumericFunction
extends NumericFunction {
    protected static final int X = 0;
    protected static final int Y = 1;
    private static final ValueEvalToNumericXlator DEFAULT_NUM_XLATOR = new ValueEvalToNumericXlator(218);

    protected ValueEvalToNumericXlator getXlator() {
        return DEFAULT_NUM_XLATOR;
    }

    protected int getMaxNumOperands() {
        return 30;
    }

    protected double[][] getNumberArray(Eval[] xops, Eval[] yops, int srcRow, short srcCol) {
        double[][] retval = new double[2][30];
        int count = 0;
        if (xops.length > this.getMaxNumOperands() || yops.length > this.getMaxNumOperands() || xops.length != yops.length) {
            retval = null;
        } else {
            int iSize = xops.length;
            for (int i = 0; i < iSize; ++i) {
                Eval xEval = xops[i];
                Eval yEval = yops[i];
                if (!XYNumericFunction.isNumberEval(xEval) || !XYNumericFunction.isNumberEval(yEval)) continue;
                retval[0] = XYNumericFunction.ensureCapacity(retval[0], count);
                retval[1] = XYNumericFunction.ensureCapacity(retval[1], count);
                retval[0][count] = XYNumericFunction.getDoubleValue(xEval);
                retval[1][count] = XYNumericFunction.getDoubleValue(yEval);
                if (Double.isNaN(retval[0][count]) || Double.isNaN(retval[1][count])) {
                    retval = null;
                    break;
                }
                ++count;
            }
        }
        if (retval != null) {
            double[][] temp = retval;
            retval[0] = XYNumericFunction.trimToSize(retval[0], count);
            retval[1] = XYNumericFunction.trimToSize(retval[1], count);
        }
        return retval;
    }

    protected double[][] getValues(Eval[] operands, int srcCellRow, short srcCellCol) {
        double[][] retval;
        block2: {
            Eval[] yEvals;
            Eval[] xEvals;
            block6: {
                block5: {
                    AreaEval ae;
                    block4: {
                        block3: {
                            retval = null;
                            if (operands.length != 2) break block2;
                            xEvals = new Eval[1];
                            yEvals = new Eval[1];
                            if (!(operands[0] instanceof AreaEval)) break block3;
                            ae = (AreaEval)operands[0];
                            xEvals = ae.getValues();
                            break block4;
                        }
                        if (operands[0] instanceof ErrorEval) break block2;
                        xEvals[0] = operands[0];
                    }
                    if (!(operands[1] instanceof AreaEval)) break block5;
                    ae = (AreaEval)operands[1];
                    yEvals = ae.getValues();
                    break block6;
                }
                if (operands[1] instanceof ErrorEval) break block2;
                yEvals[0] = operands[1];
            }
            retval = this.getNumberArray(xEvals, yEvals, srcCellRow, srcCellCol);
        }
        return retval;
    }

    protected static double[] ensureCapacity(double[] arr, int pos) {
        double[] temp = arr;
        while (pos >= arr.length) {
            arr = new double[arr.length << 2];
        }
        if (temp.length != arr.length) {
            System.arraycopy(temp, 0, arr, 0, temp.length);
        }
        return arr;
    }

    protected static double[] trimToSize(double[] arr, int len) {
        double[] tarr = arr;
        if (arr.length > len) {
            tarr = new double[len];
            System.arraycopy(arr, 0, tarr, 0, len);
        }
        return tarr;
    }

    protected static boolean isNumberEval(Eval eval) {
        boolean retval = false;
        if (eval instanceof NumberEval) {
            retval = true;
        } else if (eval instanceof RefEval) {
            RefEval re = (RefEval)eval;
            ValueEval ve = re.getInnerValueEval();
            retval = ve instanceof NumberEval;
        }
        return retval;
    }

    protected static double getDoubleValue(Eval eval) {
        double retval = 0.0;
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            retval = ne.getNumberValue();
        } else if (eval instanceof RefEval) {
            RefEval re = (RefEval)eval;
            ValueEval ve = re.getInnerValueEval();
            retval = ve instanceof NumberEval ? ((NumberEval)ve).getNumberValue() : Double.NaN;
        } else if (eval instanceof ErrorEval) {
            retval = Double.NaN;
        }
        return retval;
    }
}

