/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.net.URL;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.StringBuilder;
import scala.Tuple2;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.ScalaRunTime$;
import xsbt.boot.AppConfiguration;
import xsbt.boot.BootException;
import xsbt.boot.Configuration$;
import xsbt.boot.Find$;
import xsbt.boot.Initialize$;
import xsbt.boot.Launch$;
import xsbt.boot.LaunchConfiguration;
import xsbt.boot.Launcher$;
import xsbt.boot.Pre$;
import xsbt.boot.ResolveVersions$;
import xsbt.boot.RunConfiguration;
import xsbti.AppMain;
import xsbti.AppProvider;
import xsbti.Exit;
import xsbti.Launcher;
import xsbti.MainResult;
import xsbti.Reboot;
import xsbti.ScalaProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Launch$ {
    public static final Launch$ MODULE$;

    static {
        new Launch$();
    }

    public Launch$() {
        MODULE$ = this;
    }

    public final void launch(Function1<RunConfiguration, MainResult> run, RunConfiguration config) {
        MainResult mainResult;
        while (true) {
            Reboot reboot;
            if ((mainResult = run.apply(config)) instanceof Exit) {
                System.exit(((Exit)mainResult).code());
                return;
            }
            if (!(mainResult instanceof Reboot)) break;
            Reboot r = reboot = (Reboot)mainResult;
            config = new RunConfiguration(r.scalaVersion(), r.app(), r.baseDirectory(), new BoxedObjectArray(r.arguments()).toList());
        }
        MainResult x = mainResult;
        throw new BootException(new StringBuilder().append((Object)"Invalid main result: ").append(x).append((Object)(x == null ? "" : new StringBuilder().append((Object)" (class: ").append(x.getClass()).append((Object)")").toString())).toString());
    }

    public MainResult run(Launcher launcher, RunConfiguration config) {
        ScalaProvider scalaProvider = launcher.getScala(config.scalaVersion());
        AppProvider appProvider = scalaProvider.app(config.app());
        Object object = ScalaRunTime$.MODULE$.arrayValue(Pre$.MODULE$.toArray(config.arguments()), String.class);
        AppConfiguration appConfig = new AppConfiguration((String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object), config.workingDirectory(), appProvider);
        AppMain main = appProvider.newMain();
        return main.run(appConfig);
    }

    public void explicit(File currentDirectory, LaunchConfiguration explicit2, List<String> arguments) {
        Launcher launcher = Launcher$.MODULE$.apply(explicit2);
        this.launch(new anonfun.explicit.1(launcher), new RunConfiguration(explicit2.getScalaVersion(), explicit2.app().toID(), currentDirectory, arguments));
    }

    public void initialized(File currentDirectory, LaunchConfiguration parsed$1, List<String> arguments) {
        parsed$1.logging().debug(new anonfun.initialized.1(parsed$1));
        LaunchConfiguration resolved$1 = ResolveVersions$.MODULE$.apply(parsed$1);
        resolved$1.logging().debug(new anonfun.initialized.2(resolved$1));
        this.explicit(currentDirectory, resolved$1, arguments);
    }

    public void parsed(File currentDirectory, LaunchConfiguration parsed, List<String> arguments) {
        File propertiesFile = parsed.boot().properties();
        if (Pre$.MODULE$.isNonEmpty(parsed.boot().promptCreate()) && !propertiesFile.exists()) {
            Initialize$.MODULE$.create(propertiesFile, parsed.boot().promptCreate(), parsed.boot().enableQuick(), parsed.appProperties());
        } else if (parsed.boot().promptFill()) {
            Initialize$.MODULE$.fill(propertiesFile, parsed.appProperties());
        }
        this.initialized(currentDirectory, parsed, arguments);
    }

    public void configured(File currentDirectory, URL configLocation, List<String> arguments) {
        LaunchConfiguration config = Configuration$.MODULE$.parse(configLocation, currentDirectory);
        Tuple2<LaunchConfiguration, File> tuple2 = Find$.MODULE$.apply(config, currentDirectory);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        this.parsed(tuple2._2(), tuple2._1(), arguments);
    }

    public void apply(File currentDirectory, List<String> arguments) {
        Tuple2<URL, List<String>> tuple2 = Configuration$.MODULE$.find(arguments, currentDirectory);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        this.configured(currentDirectory, tuple2._1(), tuple2._2());
    }

    public void apply(List<String> arguments) {
        this.apply(new File("").getAbsoluteFile(), arguments);
    }
}

