/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.AbstractConflictManager;

public class FixedConflictManager
extends AbstractConflictManager {
    private Collection revisions;

    public FixedConflictManager(String[] revs) {
        this.revisions = Arrays.asList(revs);
        this.setName("fixed" + this.revisions);
    }

    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        ArrayList<IvyNode> resolved = new ArrayList<IvyNode>(conflicts.size());
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            String revision = node.getResolvedId().getRevision();
            if (!this.revisions.contains(revision)) continue;
            resolved.add(node);
        }
        return resolved;
    }
}

