/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private List ivyPatterns = new ArrayList();
    private List artifactPatterns = new ArrayList();
    private boolean m2compatible = false;

    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        if (this.m2compatible) {
            moduleRevisionId = AbstractPatternsBasedResolver.convertM2IdForResourceSearch(moduleRevisionId);
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.ivyPatterns, DefaultArtifact.newIvyArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (this.m2compatible) {
            moduleRevisionId = AbstractPatternsBasedResolver.convertM2IdForResourceSearch(moduleRevisionId);
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    protected final ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevisionId, List list, Artifact artifact, ResourceMDParser resourceMDParser, Date date) {
        ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId);
        boolean bl2 = false;
        ResolvedResource[] resolvedResourceArray = list.iterator();
        while (resolvedResourceArray.hasNext() && !bl2) {
            String string = (String)resolvedResourceArray.next();
            ResolvedResource resolvedResource = this.findResourceUsingPattern(moduleRevisionId, string, artifact, resourceMDParser, date);
            if (resolvedResource == null || hashSet.contains(resolvedResource.getRevision())) continue;
            hashSet.add(resolvedResource.getRevision());
            arrayList.add(resolvedResource);
            bl2 = !bl;
        }
        if (arrayList.size() > 1) {
            resolvedResourceArray = arrayList.toArray(new ResolvedResource[arrayList.size()]);
            return this.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
        }
        if (arrayList.size() == 1) {
            return (ResolvedResource)arrayList.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    public final ResolvedResource findResource(ResolvedResource[] resolvedResourceArray, ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, Date date) {
        String string = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        ResolvedResource resolvedResource = null;
        List list = this.getLatestStrategy().sort(resolvedResourceArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ModuleRevisionId> arrayList2 = new ArrayList<ModuleRevisionId>();
        IvyContext ivyContext = IvyContext.getContext();
        Object object = list.listIterator(list.size());
        while (object.hasPrevious()) {
            ResolvedResource resolvedResource2 = (ResolvedResource)object.previous();
            if (this.filterNames(new ArrayList<String>(Collections.singleton(resolvedResource2.getRevision()))).isEmpty()) {
                Message.debug("\t" + string + ": filtered by name: " + resolvedResource2);
                continue;
            }
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, resolvedResource2.getRevision());
            ResolveData resolveData = ivyContext.getResolveData();
            if (resolveData != null && resolveData.getReport() != null && resolveData.isBlacklisted(resolveData.getReport().getConfiguration(), moduleRevisionId2)) {
                Message.debug("\t" + string + ": blacklisted: " + resolvedResource2);
                arrayList.add(resolvedResource2.getRevision() + " (blacklisted)");
                arrayList2.add(moduleRevisionId2);
                continue;
            }
            if (!versionMatcher.accept(moduleRevisionId, moduleRevisionId2)) {
                Message.debug("\t" + string + ": rejected by version matcher: " + resolvedResource2);
                arrayList.add(resolvedResource2.getRevision());
                continue;
            }
            if (!resolvedResource2.getResource().exists()) {
                Message.debug("\t" + string + ": unreachable: " + resolvedResource2 + "; res=" + resolvedResource2.getResource());
                arrayList.add(resolvedResource2.getRevision() + " (unreachable)");
                continue;
            }
            if (date != null && resolvedResource2.getLastModified() > date.getTime()) {
                Message.verbose("\t" + string + ": too young: " + resolvedResource2);
                arrayList.add(resolvedResource2.getRevision() + " (" + resolvedResource2.getLastModified() + ")");
                continue;
            }
            if (versionMatcher.needModuleDescriptor(moduleRevisionId, moduleRevisionId2)) {
                MDResolvedResource mDResolvedResource = resourceMDParser.parse(resolvedResource2.getResource(), resolvedResource2.getRevision());
                if (mDResolvedResource == null) {
                    Message.debug("\t" + string + ": impossible to get module descriptor resource: " + resolvedResource2);
                    arrayList.add(resolvedResource2.getRevision() + " (no or bad MD)");
                    continue;
                }
                ModuleDescriptor moduleDescriptor = mDResolvedResource.getResolvedModuleRevision().getDescriptor();
                if (moduleDescriptor.isDefault()) {
                    Message.debug("\t" + string + ": default md rejected by version matcher" + "requiring module descriptor: " + resolvedResource2);
                    arrayList.add(resolvedResource2.getRevision() + " (MD)");
                    continue;
                }
                if (!versionMatcher.accept(moduleRevisionId, moduleDescriptor)) {
                    Message.debug("\t" + string + ": md rejected by version matcher: " + resolvedResource2);
                    arrayList.add(resolvedResource2.getRevision() + " (MD)");
                    continue;
                }
                resolvedResource = mDResolvedResource;
            } else {
                resolvedResource = resolvedResource2;
            }
            if (resolvedResource == null) continue;
        }
        if (resolvedResource == null && !arrayList.isEmpty()) {
            this.logAttempt(((Object)arrayList).toString());
        }
        if (resolvedResource == null && !arrayList2.isEmpty()) {
            object = ivyContext.getDependencyDescriptor();
            ivyContext.getResolveData().getNode(object.getParentRevisionId()).getConflictManager(moduleRevisionId.getModuleId()).handleAllBlacklistedRevisions$5b957239(arrayList2);
        }
        return resolvedResource;
    }

    protected Collection filterNames(Collection collection) {
        this.getSettings().filterIgnore(collection);
        return collection;
    }

    public void addIvyPattern(String string) {
        this.ivyPatterns.add(string);
    }

    public void addArtifactPattern(String string) {
        this.artifactPatterns.add(string);
    }

    public final List getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected final void setIvyPatterns(List list) {
        this.ivyPatterns = list;
    }

    protected final void setArtifactPatterns(List list) {
        this.artifactPatterns = list;
    }

    public void dumpSettings() {
        String string;
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.m2compatible);
        Message.debug("\t\tivy patterns:");
        ListIterator<Object> listIterator = Collections.unmodifiableList(this.ivyPatterns).listIterator();
        while (listIterator.hasNext()) {
            string = (String)listIterator.next();
            Message.debug("\t\t\t" + string);
        }
        Message.debug("\t\tartifact patterns:");
        listIterator = this.getArtifactPatterns().listIterator();
        while (listIterator.hasNext()) {
            string = (String)listIterator.next();
            Message.debug("\t\t\t" + string);
        }
    }

    public final boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean bl) {
        this.m2compatible = bl;
    }

    protected static ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId moduleRevisionId) {
        if (moduleRevisionId.getOrganisation() == null || moduleRevisionId.getOrganisation().indexOf(46) == -1) {
            return moduleRevisionId;
        }
        return ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation().replace('.', '/'), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), moduleRevisionId.getQualifiedExtraAttributes());
    }
}

