/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeEviction$EvictionData;
import org.apache.ivy.core.resolve.IvyNodeEviction$ModuleIdConf;
import org.apache.ivy.plugins.conflict.ConflictManager;

public final class IvyNodeEviction {
    private IvyNode node;
    private Map selectedDeps = new HashMap();
    private Map pendingConflicts = new HashMap();
    private Map evictedDeps = new HashMap();
    private Map evictedRevs = new HashMap();
    private Map evicted = new HashMap();

    public IvyNodeEviction(IvyNode ivyNode) {
        if (ivyNode == null) {
            throw new NullPointerException("node must not be null");
        }
        this.node = ivyNode;
    }

    public final Set getResolvedNodes(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.selectedDeps.get(new IvyNodeEviction$ModuleIdConf(moduleId, string));
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                hashSet.add(ivyNode.getRealNode());
            }
        }
        return hashSet;
    }

    public final Collection getResolvedRevisions(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.selectedDeps.get(new IvyNodeEviction$ModuleIdConf(moduleId, string));
        if (collection == null) {
            return new HashSet();
        }
        HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)iterator.next();
            hashSet.add(ivyNode.getId());
            hashSet.add(ivyNode.getResolvedId());
        }
        return hashSet;
    }

    public final void setResolvedNodes(ModuleId moduleId, String string, Collection collection) {
        IvyNodeEviction$ModuleIdConf ivyNodeEviction$ModuleIdConf = new IvyNodeEviction$ModuleIdConf(moduleId, string);
        this.selectedDeps.put(ivyNodeEviction$ModuleIdConf, new HashSet(collection));
    }

    public final Collection getEvictedNodes(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.evictedDeps.get(new IvyNodeEviction$ModuleIdConf(moduleId, string));
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                hashSet.add(ivyNode.getRealNode());
            }
        }
        return hashSet;
    }

    public final Collection getEvictedRevisions(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.evictedRevs.get(new IvyNodeEviction$ModuleIdConf(moduleId, string));
        if (collection == null) {
            return new HashSet();
        }
        return new HashSet(collection);
    }

    public final void setEvictedNodes(ModuleId moduleId, String string, Collection collection) {
        IvyNodeEviction$ModuleIdConf ivyNodeEviction$ModuleIdConf = new IvyNodeEviction$ModuleIdConf(moduleId, string);
        this.evictedDeps.put(ivyNodeEviction$ModuleIdConf, new HashSet(collection));
        HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)iterator.next();
            hashSet.add(ivyNode.getId());
            hashSet.add(ivyNode.getResolvedId());
        }
        this.evictedRevs.put(ivyNodeEviction$ModuleIdConf, hashSet);
    }

    public final boolean isEvicted(String string) {
        this.cleanEvicted();
        IvyNode ivyNode = this.node.getRoot();
        ModuleId moduleId = this.node.getId().getModuleId();
        Collection collection = ivyNode.getResolvedRevisions(moduleId, string);
        IvyNodeEviction$EvictionData ivyNodeEviction$EvictionData = this.getEvictedData(string);
        return ivyNode != this.node && ivyNodeEviction$EvictionData != null && (!collection.contains(this.node.getResolvedId()) || ivyNodeEviction$EvictionData.isTransitivelyEvicted());
    }

    public final boolean isCompletelyEvicted() {
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        String[] stringArray = this.node.getRootModuleConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isEvicted(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private void cleanEvicted() {
        Iterator iterator = this.evicted.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Collection collection = ((IvyNodeEviction$EvictionData)this.evicted.get(string)).getSelected();
            if (collection == null) continue;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                if (!((IvyNode)iterator2.next()).getRealNode().equals(this.node)) continue;
                iterator.remove();
            }
        }
    }

    public final void markEvicted(IvyNodeEviction$EvictionData ivyNodeEviction$EvictionData) {
        this.evicted.put(ivyNodeEviction$EvictionData.getRootModuleConf(), ivyNodeEviction$EvictionData);
    }

    public final IvyNodeEviction$EvictionData getEvictedData(String string) {
        this.cleanEvicted();
        return (IvyNodeEviction$EvictionData)this.evicted.get(string);
    }

    public final String[] getEvictedConfs() {
        this.cleanEvicted();
        return this.evicted.keySet().toArray(new String[this.evicted.keySet().size()]);
    }

    public final Collection getAllEvictingNodesDetails() {
        HashSet<String> hashSet = null;
        Iterator iterator = this.evicted.values().iterator();
        while (iterator.hasNext()) {
            IvyNodeEviction$EvictionData ivyNodeEviction$EvictionData = (IvyNodeEviction$EvictionData)iterator.next();
            Collection collection = ivyNodeEviction$EvictionData.getSelected();
            if (collection == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            if (collection.size() == 1) {
                hashSet.add(collection.iterator().next() + (ivyNodeEviction$EvictionData.getDetail() == null ? "" : " " + ivyNodeEviction$EvictionData.getDetail()));
                continue;
            }
            if (collection.size() <= 1) continue;
            hashSet.add(collection + (ivyNodeEviction$EvictionData.getDetail() == null ? "" : " " + ivyNodeEviction$EvictionData.getDetail()));
        }
        return hashSet;
    }

    public final Collection getAllEvictingConflictManagers() {
        HashSet<ConflictManager> hashSet = new HashSet<ConflictManager>();
        Iterator iterator = this.evicted.values().iterator();
        while (iterator.hasNext()) {
            IvyNodeEviction$EvictionData ivyNodeEviction$EvictionData = (IvyNodeEviction$EvictionData)iterator.next();
            hashSet.add(ivyNodeEviction$EvictionData.getConflictManager());
        }
        return hashSet;
    }

    public final IvyNodeEviction$EvictionData getEvictionDataInRoot(String string, IvyNode ivyNode) {
        Set set = this.node.getRoot().getResolvedNodes(this.node.getModuleId(), string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!((IvyNode)iterator.next()).getResolvedId().equals(this.node.getResolvedId())) continue;
            return null;
        }
        return new IvyNodeEviction$EvictionData(string, ivyNode, this.node.getRoot().getConflictManager(this.node.getModuleId()), set);
    }

    public final Collection getPendingConflicts(String string, ModuleId moduleId) {
        Collection collection = (Collection)this.pendingConflicts.get(new IvyNodeEviction$ModuleIdConf(moduleId, string));
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                hashSet.add(ivyNode.getRealNode());
            }
        }
        return hashSet;
    }

    public final void setPendingConflicts(ModuleId moduleId, String string, Collection collection) {
        IvyNodeEviction$ModuleIdConf ivyNodeEviction$ModuleIdConf = new IvyNodeEviction$ModuleIdConf(moduleId, string);
        this.pendingConflicts.put(ivyNodeEviction$ModuleIdConf, new HashSet(collection));
    }
}

