// automatically generated by `perl gen-uax29-test.pl` at $ Tue Dec  4 00:56:53 2007 $

// break-iterator-test.cpp
#include <ascension/corelib/text/break-iterator.hpp>
#include <boost/test/included/test_exec_monitor.hpp>
namespace a = ascension;
namespace t = ascension::text;

namespace {
	template<class Container>
	class ContainerInitializeContext {
	public:
		explicit ContainerInitializeContext(Container& c) throw() : c_(c) {}
		ContainerInitializeContext& operator,(typename Container::value_type e) {c_.push_back(e); return *this;}
	private:
		Container& c_;
	};
	template<class Container>
	class ContainerInitializer {
	public:
		explicit ContainerInitializer(Container& c) throw() : c_(c) {}
		ContainerInitializeContext<Container> operator=(typename Container::value_type e) {
			c_.clear(); c_.push_back(e); return ContainerInitializeContext<Container>(c_);}
	private:
		Container& c_;
	};
	template<class Container>
	inline ContainerInitializer<Container> initializeContainer(Container& c) {
		return ContainerInitializer<Container>(c);
	}

	template<template<class> class Iterator>
	void check(Iterator<t::StringCharacterIterator>& i, const std::vector<std::size_t>& indices) {
		const a::Char* const p = i.base().tell();
		// forward iteration
		for(std::vector<std::size_t>::const_iterator j = indices.begin(); j != indices.end(); ++j)
			BOOST_WARN_EQUAL((i++).base().tell(), p + *j);
		// backward iteration
		BOOST_WARN(!i.base().hasNext());	// BOOST_REQUIRE is preferred
		for(std::vector<std::size_t>::const_reverse_iterator j = indices.rbegin(); j != indices.rend(); ++j)
			BOOST_WARN_EQUAL((i--).base().tell(), p + *j);
		// random check
		BOOST_WARN(!i.base().hasPrevious());	// BOOST_REQUIRE is preferred
		for(std::vector<std::size_t>::const_iterator j = indices.begin(); j != indices.end(); ++j)
			BOOST_WARN(i.isBoundary(t::StringCharacterIterator(p, i.base().end(), p + *j)));
	}

	inline void checkGBI(const a::String& s, const std::vector<std::size_t>& indices) {
		t::StringCharacterIterator text(s);
		t::GraphemeBreakIterator<t::StringCharacterIterator> i(text);
		return check(i, indices);
	}

	inline void checkWBI(const a::String& s, const std::vector<std::size_t>& indices) {
		t::StringCharacterIterator text(s);
		t::WordBreakIterator<t::StringCharacterIterator> i(text, t::AbstractWordBreakIterator::BOUNDARY_OF_SEGMENT, t::IdentifierSyntax());
		return check<t::WordBreakIterator>(i, indices);
	}

	inline void checkSBI(const a::String& s, const std::vector<std::size_t>& indices) {
	}
}

void testGraphemeBreakIterator() {
	std::vector<std::size_t> indices;
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x0020\x0020", indices);
	checkGBI(L"\x0020\x000D", indices);
	checkGBI(L"\x0020\x000A", indices);
	checkGBI(L"\x0020\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x0020\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x0020\x1100", indices);
	checkGBI(L"\x0020\x1160", indices);
	checkGBI(L"\x0020\x11A8", indices);
	checkGBI(L"\x0020\xAC00", indices);
	checkGBI(L"\x0020\xAC01", indices);
	checkGBI(L"\x000D\x0020", indices);
	checkGBI(L"\x000D\x000D", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x000D\x000A", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x000D\x0001", indices);
	checkGBI(L"\x000D\x0300", indices);
	checkGBI(L"\x000D\x1100", indices);
	checkGBI(L"\x000D\x1160", indices);
	checkGBI(L"\x000D\x11A8", indices);
	checkGBI(L"\x000D\xAC00", indices);
	checkGBI(L"\x000D\xAC01", indices);
	checkGBI(L"\x000A\x0020", indices);
	checkGBI(L"\x000A\x000D", indices);
	checkGBI(L"\x000A\x000A", indices);
	checkGBI(L"\x000A\x0001", indices);
	checkGBI(L"\x000A\x0300", indices);
	checkGBI(L"\x000A\x1100", indices);
	checkGBI(L"\x000A\x1160", indices);
	checkGBI(L"\x000A\x11A8", indices);
	checkGBI(L"\x000A\xAC00", indices);
	checkGBI(L"\x000A\xAC01", indices);
	checkGBI(L"\x0001\x0020", indices);
	checkGBI(L"\x0001\x000D", indices);
	checkGBI(L"\x0001\x000A", indices);
	checkGBI(L"\x0001\x0001", indices);
	checkGBI(L"\x0001\x0300", indices);
	checkGBI(L"\x0001\x1100", indices);
	checkGBI(L"\x0001\x1160", indices);
	checkGBI(L"\x0001\x11A8", indices);
	checkGBI(L"\x0001\xAC00", indices);
	checkGBI(L"\x0001\xAC01", indices);
	checkGBI(L"\x0300\x0020", indices);
	checkGBI(L"\x0300\x000D", indices);
	checkGBI(L"\x0300\x000A", indices);
	checkGBI(L"\x0300\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x0300\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x0300\x1100", indices);
	checkGBI(L"\x0300\x1160", indices);
	checkGBI(L"\x0300\x11A8", indices);
	checkGBI(L"\x0300\xAC00", indices);
	checkGBI(L"\x0300\xAC01", indices);
	checkGBI(L"\x1100\x0020", indices);
	checkGBI(L"\x1100\x000D", indices);
	checkGBI(L"\x1100\x000A", indices);
	checkGBI(L"\x1100\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x1100\x0300", indices);
	checkGBI(L"\x1100\x1100", indices);
	checkGBI(L"\x1100\x1160", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x1100\x11A8", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x1100\xAC00", indices);
	checkGBI(L"\x1100\xAC01", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x1160\x0020", indices);
	checkGBI(L"\x1160\x000D", indices);
	checkGBI(L"\x1160\x000A", indices);
	checkGBI(L"\x1160\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x1160\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x1160\x1100", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x1160\x1160", indices);
	checkGBI(L"\x1160\x11A8", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x1160\xAC00", indices);
	checkGBI(L"\x1160\xAC01", indices);
	checkGBI(L"\x11A8\x0020", indices);
	checkGBI(L"\x11A8\x000D", indices);
	checkGBI(L"\x11A8\x000A", indices);
	checkGBI(L"\x11A8\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x11A8\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x11A8\x1100", indices);
	checkGBI(L"\x11A8\x1160", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\x11A8\x11A8", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\x11A8\xAC00", indices);
	checkGBI(L"\x11A8\xAC01", indices);
	checkGBI(L"\xAC00\x0020", indices);
	checkGBI(L"\xAC00\x000D", indices);
	checkGBI(L"\xAC00\x000A", indices);
	checkGBI(L"\xAC00\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\xAC00\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\xAC00\x1100", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\xAC00\x1160", indices);
	checkGBI(L"\xAC00\x11A8", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\xAC00\xAC00", indices);
	checkGBI(L"\xAC00\xAC01", indices);
	checkGBI(L"\xAC01\x0020", indices);
	checkGBI(L"\xAC01\x000D", indices);
	checkGBI(L"\xAC01\x000A", indices);
	checkGBI(L"\xAC01\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\xAC01\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\xAC01\x1100", indices);
	checkGBI(L"\xAC01\x1160", indices);
	initializeContainer(indices) = 0, 2;
	checkGBI(L"\xAC01\x11A8", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkGBI(L"\xAC01\xAC00", indices);
	checkGBI(L"\xAC01\xAC01", indices);
}

void testWordBreakIterator() {
	std::vector<std::size_t> indices;
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0020\x0020", indices);
	checkWBI(L"\x0020\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0020\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0020\x000A", indices);
	checkWBI(L"\x0020\x000D", indices);
	checkWBI(L"\x0020\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0020\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0020\x3031", indices);
	checkWBI(L"\x0020\x0041", indices);
	checkWBI(L"\x0020\x0027", indices);
	checkWBI(L"\x0020\x002C", indices);
	checkWBI(L"\x0020\x0030", indices);
	checkWBI(L"\x0020\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0020\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0020\x0061\x003A", indices);
	checkWBI(L"\x0020\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0020\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0020\x0061\x002C", indices);
	checkWBI(L"\x0020\x0031\x003A", indices);
	checkWBI(L"\x0020\x0031\x0027", indices);
	checkWBI(L"\x0020\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0020\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0001\x0020", indices);
	checkWBI(L"\x0001\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0001\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0001\x000A", indices);
	checkWBI(L"\x0001\x000D", indices);
	checkWBI(L"\x0001\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0001\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0001\x3031", indices);
	checkWBI(L"\x0001\x0041", indices);
	checkWBI(L"\x0001\x0027", indices);
	checkWBI(L"\x0001\x002C", indices);
	checkWBI(L"\x0001\x0030", indices);
	checkWBI(L"\x0001\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0001\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0001\x0061\x003A", indices);
	checkWBI(L"\x0001\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0001\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0001\x0061\x002C", indices);
	checkWBI(L"\x0001\x0031\x003A", indices);
	checkWBI(L"\x0001\x0031\x0027", indices);
	checkWBI(L"\x0001\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0001\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0300\x0020", indices);
	checkWBI(L"\x0300\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0300\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0300\x000A", indices);
	checkWBI(L"\x0300\x000D", indices);
	checkWBI(L"\x0300\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0300\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0300\x3031", indices);
	checkWBI(L"\x0300\x0041", indices);
	checkWBI(L"\x0300\x0027", indices);
	checkWBI(L"\x0300\x002C", indices);
	checkWBI(L"\x0300\x0030", indices);
	checkWBI(L"\x0300\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0300\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0300\x0061\x003A", indices);
	checkWBI(L"\x0300\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0300\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0300\x0061\x002C", indices);
	checkWBI(L"\x0300\x0031\x003A", indices);
	checkWBI(L"\x0300\x0031\x0027", indices);
	checkWBI(L"\x0300\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0300\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x000A\x0020", indices);
	checkWBI(L"\x000A\x0001", indices);
	checkWBI(L"\x000A\x0300", indices);
	checkWBI(L"\x000A\x000A", indices);
	checkWBI(L"\x000A\x000D", indices);
	checkWBI(L"\x000A\x0085", indices);
	checkWBI(L"\x000A\x00AD", indices);
	checkWBI(L"\x000A\x3031", indices);
	checkWBI(L"\x000A\x0041", indices);
	checkWBI(L"\x000A\x0027", indices);
	checkWBI(L"\x000A\x002C", indices);
	checkWBI(L"\x000A\x0030", indices);
	checkWBI(L"\x000A\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x000A\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x000A\x0061\x003A", indices);
	checkWBI(L"\x000A\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x000A\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x000A\x0061\x002C", indices);
	checkWBI(L"\x000A\x0031\x003A", indices);
	checkWBI(L"\x000A\x0031\x0027", indices);
	checkWBI(L"\x000A\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x000A\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x000D\x0020", indices);
	checkWBI(L"\x000D\x0001", indices);
	checkWBI(L"\x000D\x0300", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x000D\x000A", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x000D\x000D", indices);
	checkWBI(L"\x000D\x0085", indices);
	checkWBI(L"\x000D\x00AD", indices);
	checkWBI(L"\x000D\x3031", indices);
	checkWBI(L"\x000D\x0041", indices);
	checkWBI(L"\x000D\x0027", indices);
	checkWBI(L"\x000D\x002C", indices);
	checkWBI(L"\x000D\x0030", indices);
	checkWBI(L"\x000D\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x000D\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x000D\x0061\x003A", indices);
	checkWBI(L"\x000D\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x000D\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x000D\x0061\x002C", indices);
	checkWBI(L"\x000D\x0031\x003A", indices);
	checkWBI(L"\x000D\x0031\x0027", indices);
	checkWBI(L"\x000D\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x000D\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0085\x0020", indices);
	checkWBI(L"\x0085\x0001", indices);
	checkWBI(L"\x0085\x0300", indices);
	checkWBI(L"\x0085\x000A", indices);
	checkWBI(L"\x0085\x000D", indices);
	checkWBI(L"\x0085\x0085", indices);
	checkWBI(L"\x0085\x00AD", indices);
	checkWBI(L"\x0085\x3031", indices);
	checkWBI(L"\x0085\x0041", indices);
	checkWBI(L"\x0085\x0027", indices);
	checkWBI(L"\x0085\x002C", indices);
	checkWBI(L"\x0085\x0030", indices);
	checkWBI(L"\x0085\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0085\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0085\x0061\x003A", indices);
	checkWBI(L"\x0085\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0085\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0085\x0061\x002C", indices);
	checkWBI(L"\x0085\x0031\x003A", indices);
	checkWBI(L"\x0085\x0031\x0027", indices);
	checkWBI(L"\x0085\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0085\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x00AD\x0020", indices);
	checkWBI(L"\x00AD\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x00AD\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x00AD\x000A", indices);
	checkWBI(L"\x00AD\x000D", indices);
	checkWBI(L"\x00AD\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x00AD\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x00AD\x3031", indices);
	checkWBI(L"\x00AD\x0041", indices);
	checkWBI(L"\x00AD\x0027", indices);
	checkWBI(L"\x00AD\x002C", indices);
	checkWBI(L"\x00AD\x0030", indices);
	checkWBI(L"\x00AD\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x00AD\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x00AD\x0061\x003A", indices);
	checkWBI(L"\x00AD\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x00AD\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x00AD\x0061\x002C", indices);
	checkWBI(L"\x00AD\x0031\x003A", indices);
	checkWBI(L"\x00AD\x0031\x0027", indices);
	checkWBI(L"\x00AD\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x00AD\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x3031\x0020", indices);
	checkWBI(L"\x3031\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x3031\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x3031\x000A", indices);
	checkWBI(L"\x3031\x000D", indices);
	checkWBI(L"\x3031\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x3031\x00AD", indices);
	checkWBI(L"\x3031\x3031", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x3031\x0041", indices);
	checkWBI(L"\x3031\x0027", indices);
	checkWBI(L"\x3031\x002C", indices);
	checkWBI(L"\x3031\x0030", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x3031\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x3031\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x3031\x0061\x003A", indices);
	checkWBI(L"\x3031\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x3031\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x3031\x0061\x002C", indices);
	checkWBI(L"\x3031\x0031\x003A", indices);
	checkWBI(L"\x3031\x0031\x0027", indices);
	checkWBI(L"\x3031\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x3031\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0041\x0020", indices);
	checkWBI(L"\x0041\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0041\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0041\x000A", indices);
	checkWBI(L"\x0041\x000D", indices);
	checkWBI(L"\x0041\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0041\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0041\x3031", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0041\x0041", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0041\x0027", indices);
	checkWBI(L"\x0041\x002C", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0041\x0030", indices);
	checkWBI(L"\x0041\x005F", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0041\x0061\x2060", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0041\x0061\x003A", indices);
	checkWBI(L"\x0041\x0061\x0027", indices);
	initializeContainer(indices) = 0, 2, 4;
	checkWBI(L"\x0041\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0041\x0061\x002C", indices);
	checkWBI(L"\x0041\x0031\x003A", indices);
	checkWBI(L"\x0041\x0031\x0027", indices);
	checkWBI(L"\x0041\x0031\x002C", indices);
	initializeContainer(indices) = 0, 2, 4;
	checkWBI(L"\x0041\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0027\x0020", indices);
	checkWBI(L"\x0027\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0027\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0027\x000A", indices);
	checkWBI(L"\x0027\x000D", indices);
	checkWBI(L"\x0027\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0027\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0027\x3031", indices);
	checkWBI(L"\x0027\x0041", indices);
	checkWBI(L"\x0027\x0027", indices);
	checkWBI(L"\x0027\x002C", indices);
	checkWBI(L"\x0027\x0030", indices);
	checkWBI(L"\x0027\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0027\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0027\x0061\x003A", indices);
	checkWBI(L"\x0027\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0027\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0027\x0061\x002C", indices);
	checkWBI(L"\x0027\x0031\x003A", indices);
	checkWBI(L"\x0027\x0031\x0027", indices);
	checkWBI(L"\x0027\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0027\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x002C\x0020", indices);
	checkWBI(L"\x002C\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x002C\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x002C\x000A", indices);
	checkWBI(L"\x002C\x000D", indices);
	checkWBI(L"\x002C\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x002C\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x002C\x3031", indices);
	checkWBI(L"\x002C\x0041", indices);
	checkWBI(L"\x002C\x0027", indices);
	checkWBI(L"\x002C\x002C", indices);
	checkWBI(L"\x002C\x0030", indices);
	checkWBI(L"\x002C\x005F", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x002C\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x002C\x0061\x003A", indices);
	checkWBI(L"\x002C\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x002C\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x002C\x0061\x002C", indices);
	checkWBI(L"\x002C\x0031\x003A", indices);
	checkWBI(L"\x002C\x0031\x0027", indices);
	checkWBI(L"\x002C\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x002C\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0030\x0020", indices);
	checkWBI(L"\x0030\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0030\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0030\x000A", indices);
	checkWBI(L"\x0030\x000D", indices);
	checkWBI(L"\x0030\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0030\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0030\x3031", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0030\x0041", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x0030\x0027", indices);
	checkWBI(L"\x0030\x002C", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0030\x0030", indices);
	checkWBI(L"\x0030\x005F", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0030\x0061\x2060", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0030\x0061\x003A", indices);
	checkWBI(L"\x0030\x0061\x0027", indices);
	initializeContainer(indices) = 0, 2, 4;
	checkWBI(L"\x0030\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0030\x0061\x002C", indices);
	checkWBI(L"\x0030\x0031\x003A", indices);
	checkWBI(L"\x0030\x0031\x0027", indices);
	checkWBI(L"\x0030\x0031\x002C", indices);
	initializeContainer(indices) = 0, 2, 4;
	checkWBI(L"\x0030\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x005F\x0020", indices);
	checkWBI(L"\x005F\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x005F\x0300", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x005F\x000A", indices);
	checkWBI(L"\x005F\x000D", indices);
	checkWBI(L"\x005F\x0085", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x005F\x00AD", indices);
	checkWBI(L"\x005F\x3031", indices);
	checkWBI(L"\x005F\x0041", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkWBI(L"\x005F\x0027", indices);
	checkWBI(L"\x005F\x002C", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x005F\x0030", indices);
	checkWBI(L"\x005F\x005F", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x005F\x0061\x2060", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x005F\x0061\x003A", indices);
	checkWBI(L"\x005F\x0061\x0027", indices);
	initializeContainer(indices) = 0, 2, 4;
	checkWBI(L"\x005F\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x005F\x0061\x002C", indices);
	checkWBI(L"\x005F\x0031\x003A", indices);
	checkWBI(L"\x005F\x0031\x0027", indices);
	checkWBI(L"\x005F\x0031\x002C", indices);
	initializeContainer(indices) = 0, 2, 4;
	checkWBI(L"\x005F\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0061\x2060\x0020", indices);
	checkWBI(L"\x0061\x2060\x0001", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0061\x2060\x0300", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0061\x2060\x000A", indices);
	checkWBI(L"\x0061\x2060\x000D", indices);
	checkWBI(L"\x0061\x2060\x0085", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0061\x2060\x00AD", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0061\x2060\x3031", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0061\x2060\x0041", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkWBI(L"\x0061\x2060\x0027", indices);
	checkWBI(L"\x0061\x2060\x002C", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0061\x2060\x0030", indices);
	checkWBI(L"\x0061\x2060\x005F", indices);
	initializeContainer(indices) = 0, 4;
	checkWBI(L"\x0061\x2060\x0061\x2060", indices);
	initializeContainer(indices) = 0, 3, 4;
	checkWBI(L"\x0061\x2060\x0061\x003A", indices);
	checkWBI(L"\x0061\x2060\x0061\x0027", indices);
	initializeContainer(indices) = 0, 3, 5;
	checkWBI(L"\x0061\x2060\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 3, 4;
	checkWBI(L"\x0061\x2060\x0061\x002C", indices);
	checkWBI(L"\x0061\x2060\x0031\x003A", indices);
	checkWBI(L"\x0061\x2060\x0031\x0027", indices);
	checkWBI(L"\x0061\x2060\x0031\x002C", indices);
	initializeContainer(indices) = 0, 3, 5;
	checkWBI(L"\x0061\x2060\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x003A\x0020", indices);
	checkWBI(L"\x0061\x003A\x0001", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0061\x003A\x0300", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x003A\x000A", indices);
	checkWBI(L"\x0061\x003A\x000D", indices);
	checkWBI(L"\x0061\x003A\x0085", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0061\x003A\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x003A\x3031", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0061\x003A\x0041", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x003A\x0027", indices);
	checkWBI(L"\x0061\x003A\x002C", indices);
	checkWBI(L"\x0061\x003A\x0030", indices);
	checkWBI(L"\x0061\x003A\x005F", indices);
	initializeContainer(indices) = 0, 4;
	checkWBI(L"\x0061\x003A\x0061\x2060", indices);
	initializeContainer(indices) = 0, 3, 4;
	checkWBI(L"\x0061\x003A\x0061\x003A", indices);
	checkWBI(L"\x0061\x003A\x0061\x0027", indices);
	initializeContainer(indices) = 0, 3, 5;
	checkWBI(L"\x0061\x003A\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 3, 4;
	checkWBI(L"\x0061\x003A\x0061\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0061\x003A\x0031\x003A", indices);
	checkWBI(L"\x0061\x003A\x0031\x0027", indices);
	checkWBI(L"\x0061\x003A\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0061\x003A\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x0027\x0020", indices);
	checkWBI(L"\x0061\x0027\x0001", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0061\x0027\x0300", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x0027\x000A", indices);
	checkWBI(L"\x0061\x0027\x000D", indices);
	checkWBI(L"\x0061\x0027\x0085", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0061\x0027\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x0027\x3031", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0061\x0027\x0041", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x0027\x0027", indices);
	checkWBI(L"\x0061\x0027\x002C", indices);
	checkWBI(L"\x0061\x0027\x0030", indices);
	checkWBI(L"\x0061\x0027\x005F", indices);
	initializeContainer(indices) = 0, 4;
	checkWBI(L"\x0061\x0027\x0061\x2060", indices);
	initializeContainer(indices) = 0, 3, 4;
	checkWBI(L"\x0061\x0027\x0061\x003A", indices);
	checkWBI(L"\x0061\x0027\x0061\x0027", indices);
	initializeContainer(indices) = 0, 3, 5;
	checkWBI(L"\x0061\x0027\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 3, 4;
	checkWBI(L"\x0061\x0027\x0061\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0061\x0027\x0031\x003A", indices);
	checkWBI(L"\x0061\x0027\x0031\x0027", indices);
	checkWBI(L"\x0061\x0027\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0061\x0027\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0061\x0027\x2060\x0020", indices);
	checkWBI(L"\x0061\x0027\x2060\x0001", indices);
	initializeContainer(indices) = 0, 1, 4;
	checkWBI(L"\x0061\x0027\x2060\x0300", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0061\x0027\x2060\x000A", indices);
	checkWBI(L"\x0061\x0027\x2060\x000D", indices);
	checkWBI(L"\x0061\x0027\x2060\x0085", indices);
	initializeContainer(indices) = 0, 1, 4;
	checkWBI(L"\x0061\x0027\x2060\x00AD", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0061\x0027\x2060\x3031", indices);
	initializeContainer(indices) = 0, 4;
	checkWBI(L"\x0061\x0027\x2060\x0041", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0061\x0027\x2060\x0027", indices);
	checkWBI(L"\x0061\x0027\x2060\x002C", indices);
	checkWBI(L"\x0061\x0027\x2060\x0030", indices);
	checkWBI(L"\x0061\x0027\x2060\x005F", indices);
	initializeContainer(indices) = 0, 5;
	checkWBI(L"\x0061\x0027\x2060\x0061\x2060", indices);
	initializeContainer(indices) = 0, 4, 5;
	checkWBI(L"\x0061\x0027\x2060\x0061\x003A", indices);
	checkWBI(L"\x0061\x0027\x2060\x0061\x0027", indices);
	initializeContainer(indices) = 0, 4, 6;
	checkWBI(L"\x0061\x0027\x2060\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 4, 5;
	checkWBI(L"\x0061\x0027\x2060\x0061\x002C", indices);
	initializeContainer(indices) = 0, 1, 3, 4, 5;
	checkWBI(L"\x0061\x0027\x2060\x0031\x003A", indices);
	checkWBI(L"\x0061\x0027\x2060\x0031\x0027", indices);
	checkWBI(L"\x0061\x0027\x2060\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 3, 4, 6;
	checkWBI(L"\x0061\x0027\x2060\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x002C\x0020", indices);
	checkWBI(L"\x0061\x002C\x0001", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0061\x002C\x0300", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x002C\x000A", indices);
	checkWBI(L"\x0061\x002C\x000D", indices);
	checkWBI(L"\x0061\x002C\x0085", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0061\x002C\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0061\x002C\x3031", indices);
	checkWBI(L"\x0061\x002C\x0041", indices);
	checkWBI(L"\x0061\x002C\x0027", indices);
	checkWBI(L"\x0061\x002C\x002C", indices);
	checkWBI(L"\x0061\x002C\x0030", indices);
	checkWBI(L"\x0061\x002C\x005F", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0061\x002C\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0061\x002C\x0061\x003A", indices);
	checkWBI(L"\x0061\x002C\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0061\x002C\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0061\x002C\x0061\x002C", indices);
	checkWBI(L"\x0061\x002C\x0031\x003A", indices);
	checkWBI(L"\x0061\x002C\x0031\x0027", indices);
	checkWBI(L"\x0061\x002C\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0061\x002C\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x003A\x0020", indices);
	checkWBI(L"\x0031\x003A\x0001", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0031\x003A\x0300", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x003A\x000A", indices);
	checkWBI(L"\x0031\x003A\x000D", indices);
	checkWBI(L"\x0031\x003A\x0085", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0031\x003A\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x003A\x3031", indices);
	checkWBI(L"\x0031\x003A\x0041", indices);
	checkWBI(L"\x0031\x003A\x0027", indices);
	checkWBI(L"\x0031\x003A\x002C", indices);
	checkWBI(L"\x0031\x003A\x0030", indices);
	checkWBI(L"\x0031\x003A\x005F", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0031\x003A\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0031\x003A\x0061\x003A", indices);
	checkWBI(L"\x0031\x003A\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0031\x003A\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0031\x003A\x0061\x002C", indices);
	checkWBI(L"\x0031\x003A\x0031\x003A", indices);
	checkWBI(L"\x0031\x003A\x0031\x0027", indices);
	checkWBI(L"\x0031\x003A\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0031\x003A\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x0027\x0020", indices);
	checkWBI(L"\x0031\x0027\x0001", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0031\x0027\x0300", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x0027\x000A", indices);
	checkWBI(L"\x0031\x0027\x000D", indices);
	checkWBI(L"\x0031\x0027\x0085", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0031\x0027\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x0027\x3031", indices);
	checkWBI(L"\x0031\x0027\x0041", indices);
	checkWBI(L"\x0031\x0027\x0027", indices);
	checkWBI(L"\x0031\x0027\x002C", indices);
	checkWBI(L"\x0031\x0027\x0030", indices);
	checkWBI(L"\x0031\x0027\x005F", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0031\x0027\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0031\x0027\x0061\x003A", indices);
	checkWBI(L"\x0031\x0027\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0031\x0027\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0031\x0027\x0061\x002C", indices);
	checkWBI(L"\x0031\x0027\x0031\x003A", indices);
	checkWBI(L"\x0031\x0027\x0031\x0027", indices);
	checkWBI(L"\x0031\x0027\x0031\x002C", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0031\x0027\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x002C\x0020", indices);
	checkWBI(L"\x0031\x002C\x0001", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0031\x002C\x0300", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x002C\x000A", indices);
	checkWBI(L"\x0031\x002C\x000D", indices);
	checkWBI(L"\x0031\x002C\x0085", indices);
	initializeContainer(indices) = 0, 1, 3;
	checkWBI(L"\x0031\x002C\x00AD", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x002C\x3031", indices);
	checkWBI(L"\x0031\x002C\x0041", indices);
	checkWBI(L"\x0031\x002C\x0027", indices);
	checkWBI(L"\x0031\x002C\x002C", indices);
	initializeContainer(indices) = 0, 3;
	checkWBI(L"\x0031\x002C\x0030", indices);
	initializeContainer(indices) = 0, 1, 2, 3;
	checkWBI(L"\x0031\x002C\x005F", indices);
	initializeContainer(indices) = 0, 1, 2, 4;
	checkWBI(L"\x0031\x002C\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0031\x002C\x0061\x003A", indices);
	checkWBI(L"\x0031\x002C\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 5;
	checkWBI(L"\x0031\x002C\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 4;
	checkWBI(L"\x0031\x002C\x0061\x002C", indices);
	initializeContainer(indices) = 0, 3, 4;
	checkWBI(L"\x0031\x002C\x0031\x003A", indices);
	checkWBI(L"\x0031\x002C\x0031\x0027", indices);
	checkWBI(L"\x0031\x002C\x0031\x002C", indices);
	initializeContainer(indices) = 0, 3, 5;
	checkWBI(L"\x0031\x002C\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0031\x002E\x2060\x0020", indices);
	checkWBI(L"\x0031\x002E\x2060\x0001", indices);
	initializeContainer(indices) = 0, 1, 4;
	checkWBI(L"\x0031\x002E\x2060\x0300", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0031\x002E\x2060\x000A", indices);
	checkWBI(L"\x0031\x002E\x2060\x000D", indices);
	checkWBI(L"\x0031\x002E\x2060\x0085", indices);
	initializeContainer(indices) = 0, 1, 4;
	checkWBI(L"\x0031\x002E\x2060\x00AD", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0031\x002E\x2060\x3031", indices);
	checkWBI(L"\x0031\x002E\x2060\x0041", indices);
	checkWBI(L"\x0031\x002E\x2060\x0027", indices);
	checkWBI(L"\x0031\x002E\x2060\x002C", indices);
	initializeContainer(indices) = 0, 4;
	checkWBI(L"\x0031\x002E\x2060\x0030", indices);
	initializeContainer(indices) = 0, 1, 3, 4;
	checkWBI(L"\x0031\x002E\x2060\x005F", indices);
	initializeContainer(indices) = 0, 1, 3, 5;
	checkWBI(L"\x0031\x002E\x2060\x0061\x2060", indices);
	initializeContainer(indices) = 0, 1, 3, 4, 5;
	checkWBI(L"\x0031\x002E\x2060\x0061\x003A", indices);
	checkWBI(L"\x0031\x002E\x2060\x0061\x0027", indices);
	initializeContainer(indices) = 0, 1, 3, 4, 6;
	checkWBI(L"\x0031\x002E\x2060\x0061\x0027\x2060", indices);
	initializeContainer(indices) = 0, 1, 3, 4, 5;
	checkWBI(L"\x0031\x002E\x2060\x0061\x002C", indices);
	initializeContainer(indices) = 0, 4, 5;
	checkWBI(L"\x0031\x002E\x2060\x0031\x003A", indices);
	checkWBI(L"\x0031\x002E\x2060\x0031\x0027", indices);
	checkWBI(L"\x0031\x002E\x2060\x0031\x002C", indices);
	initializeContainer(indices) = 0, 4, 6;
	checkWBI(L"\x0031\x002E\x2060\x0031\x002E\x2060", indices);
	initializeContainer(indices) = 0, 5;
	checkWBI(L"\x0063\x0061\x006E\x0027\x0074", indices);
	checkWBI(L"\x0063\x0061\x006E\x2019\x0074", indices);
	checkWBI(L"\x0061\x0062\x00AD\x0062\x0079", indices);
	initializeContainer(indices) = 0, 1, 2, 3, 12, 13, 14;
	checkWBI(L"\x0061\x0024\x002D\x0033\x0034\x002C\x0035\x0036\x0037\x002E\x0031\x0034\x0025\x0062", indices);
	initializeContainer(indices) = 0, 2;
	checkWBI(L"\x0033\x0061", indices);
	initializeContainer(indices) = 0, 1, 12;
	checkWBI(L"\x2060\x0063\x2060\x0061\x2060\x006E\x2060\x0027\x2060\x0074\x2060\x2060", indices);
	checkWBI(L"\x2060\x0063\x2060\x0061\x2060\x006E\x2060\x2019\x2060\x0074\x2060\x2060", indices);
	checkWBI(L"\x2060\x0061\x2060\x0062\x2060\x00AD\x2060\x0062\x2060\x0079\x2060\x2060", indices);
	initializeContainer(indices) = 0, 1, 3, 5, 7, 25, 27, 30;
	checkWBI(L"\x2060\x0061\x2060\x0024\x2060\x002D\x2060\x0033\x2060\x0034\x2060\x002C\x2060\x0035\x2060\x0036\x2060\x0037\x2060\x002E\x2060\x0031\x2060\x0034\x2060\x0025\x2060\x0062\x2060\x2060", indices);
	initializeContainer(indices) = 0, 1, 6;
	checkWBI(L"\x2060\x0033\x2060\x0061\x2060\x2060", indices);
}

void testSentenceBreakIterator() {
	std::vector<std::size_t> indices;
	initializeContainer(indices) = 0, 2;
	checkSBI(L"\x0023\x0023", indices);
	checkSBI(L"\x0023\x0001", indices);
	checkSBI(L"\x0023\x0300", indices);
	checkSBI(L"\x0023\x00AD", indices);
	checkSBI(L"\x0023\x000A", indices);
	checkSBI(L"\x0023\x000D", indices);
	checkSBI(L"\x0023\x0085", indices);
	checkSBI(L"\x0023\x0009", indices);
	checkSBI(L"\x0023\x0020", indices);
	checkSBI(L"\x0023\x0061", indices);
	checkSBI(L"\x0023\x0041", indices);
	checkSBI(L"\x0023\x00A0", indices);
	checkSBI(L"\x0023\x0030", indices);
	checkSBI(L"\x0023\x002E", indices);
	checkSBI(L"\x0023\x0021", indices);
	checkSBI(L"\x0023\x0022", indices);
	checkSBI(L"\x0001\x0023", indices);
	checkSBI(L"\x0001\x0001", indices);
	checkSBI(L"\x0001\x0300", indices);
	checkSBI(L"\x0001\x00AD", indices);
	checkSBI(L"\x0001\x000A", indices);
	checkSBI(L"\x0001\x000D", indices);
	checkSBI(L"\x0001\x0085", indices);
	checkSBI(L"\x0001\x0009", indices);
	checkSBI(L"\x0001\x0020", indices);
	checkSBI(L"\x0001\x0061", indices);
	checkSBI(L"\x0001\x0041", indices);
	checkSBI(L"\x0001\x00A0", indices);
	checkSBI(L"\x0001\x0030", indices);
	checkSBI(L"\x0001\x002E", indices);
	checkSBI(L"\x0001\x0021", indices);
	checkSBI(L"\x0001\x0022", indices);
	checkSBI(L"\x0300\x0023", indices);
	checkSBI(L"\x0300\x0001", indices);
	checkSBI(L"\x0300\x0300", indices);
	checkSBI(L"\x0300\x00AD", indices);
	checkSBI(L"\x0300\x000A", indices);
	checkSBI(L"\x0300\x000D", indices);
	checkSBI(L"\x0300\x0085", indices);
	checkSBI(L"\x0300\x0009", indices);
	checkSBI(L"\x0300\x0020", indices);
	checkSBI(L"\x0300\x0061", indices);
	checkSBI(L"\x0300\x0041", indices);
	checkSBI(L"\x0300\x00A0", indices);
	checkSBI(L"\x0300\x0030", indices);
	checkSBI(L"\x0300\x002E", indices);
	checkSBI(L"\x0300\x0021", indices);
	checkSBI(L"\x0300\x0022", indices);
	checkSBI(L"\x00AD\x0023", indices);
	checkSBI(L"\x00AD\x0001", indices);
	checkSBI(L"\x00AD\x0300", indices);
	checkSBI(L"\x00AD\x00AD", indices);
	checkSBI(L"\x00AD\x000A", indices);
	checkSBI(L"\x00AD\x000D", indices);
	checkSBI(L"\x00AD\x0085", indices);
	checkSBI(L"\x00AD\x0009", indices);
	checkSBI(L"\x00AD\x0020", indices);
	checkSBI(L"\x00AD\x0061", indices);
	checkSBI(L"\x00AD\x0041", indices);
	checkSBI(L"\x00AD\x00A0", indices);
	checkSBI(L"\x00AD\x0030", indices);
	checkSBI(L"\x00AD\x002E", indices);
	checkSBI(L"\x00AD\x0021", indices);
	checkSBI(L"\x00AD\x0022", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkSBI(L"\x000A\x0023", indices);
	checkSBI(L"\x000A\x0001", indices);
	checkSBI(L"\x000A\x0300", indices);
	checkSBI(L"\x000A\x00AD", indices);
	checkSBI(L"\x000A\x000A", indices);
	checkSBI(L"\x000A\x000D", indices);
	checkSBI(L"\x000A\x0085", indices);
	checkSBI(L"\x000A\x0009", indices);
	checkSBI(L"\x000A\x0020", indices);
	checkSBI(L"\x000A\x0061", indices);
	checkSBI(L"\x000A\x0041", indices);
	checkSBI(L"\x000A\x00A0", indices);
	checkSBI(L"\x000A\x0030", indices);
	checkSBI(L"\x000A\x002E", indices);
	checkSBI(L"\x000A\x0021", indices);
	checkSBI(L"\x000A\x0022", indices);
	checkSBI(L"\x000D\x0023", indices);
	checkSBI(L"\x000D\x0001", indices);
	checkSBI(L"\x000D\x0300", indices);
	checkSBI(L"\x000D\x00AD", indices);
	initializeContainer(indices) = 0, 2;
	checkSBI(L"\x000D\x000A", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkSBI(L"\x000D\x000D", indices);
	checkSBI(L"\x000D\x0085", indices);
	checkSBI(L"\x000D\x0009", indices);
	checkSBI(L"\x000D\x0020", indices);
	checkSBI(L"\x000D\x0061", indices);
	checkSBI(L"\x000D\x0041", indices);
	checkSBI(L"\x000D\x00A0", indices);
	checkSBI(L"\x000D\x0030", indices);
	checkSBI(L"\x000D\x002E", indices);
	checkSBI(L"\x000D\x0021", indices);
	checkSBI(L"\x000D\x0022", indices);
	checkSBI(L"\x0085\x0023", indices);
	checkSBI(L"\x0085\x0001", indices);
	checkSBI(L"\x0085\x0300", indices);
	checkSBI(L"\x0085\x00AD", indices);
	checkSBI(L"\x0085\x000A", indices);
	checkSBI(L"\x0085\x000D", indices);
	checkSBI(L"\x0085\x0085", indices);
	checkSBI(L"\x0085\x0009", indices);
	checkSBI(L"\x0085\x0020", indices);
	checkSBI(L"\x0085\x0061", indices);
	checkSBI(L"\x0085\x0041", indices);
	checkSBI(L"\x0085\x00A0", indices);
	checkSBI(L"\x0085\x0030", indices);
	checkSBI(L"\x0085\x002E", indices);
	checkSBI(L"\x0085\x0021", indices);
	checkSBI(L"\x0085\x0022", indices);
	initializeContainer(indices) = 0, 2;
	checkSBI(L"\x0009\x0023", indices);
	checkSBI(L"\x0009\x0001", indices);
	checkSBI(L"\x0009\x0300", indices);
	checkSBI(L"\x0009\x00AD", indices);
	checkSBI(L"\x0009\x000A", indices);
	checkSBI(L"\x0009\x000D", indices);
	checkSBI(L"\x0009\x0085", indices);
	checkSBI(L"\x0009\x0009", indices);
	checkSBI(L"\x0009\x0020", indices);
	checkSBI(L"\x0009\x0061", indices);
	checkSBI(L"\x0009\x0041", indices);
	checkSBI(L"\x0009\x00A0", indices);
	checkSBI(L"\x0009\x0030", indices);
	checkSBI(L"\x0009\x002E", indices);
	checkSBI(L"\x0009\x0021", indices);
	checkSBI(L"\x0009\x0022", indices);
	checkSBI(L"\x0020\x0023", indices);
	checkSBI(L"\x0020\x0001", indices);
	checkSBI(L"\x0020\x0300", indices);
	checkSBI(L"\x0020\x00AD", indices);
	checkSBI(L"\x0020\x000A", indices);
	checkSBI(L"\x0020\x000D", indices);
	checkSBI(L"\x0020\x0085", indices);
	checkSBI(L"\x0020\x0009", indices);
	checkSBI(L"\x0020\x0020", indices);
	checkSBI(L"\x0020\x0061", indices);
	checkSBI(L"\x0020\x0041", indices);
	checkSBI(L"\x0020\x00A0", indices);
	checkSBI(L"\x0020\x0030", indices);
	checkSBI(L"\x0020\x002E", indices);
	checkSBI(L"\x0020\x0021", indices);
	checkSBI(L"\x0020\x0022", indices);
	checkSBI(L"\x0061\x0023", indices);
	checkSBI(L"\x0061\x0001", indices);
	checkSBI(L"\x0061\x0300", indices);
	checkSBI(L"\x0061\x00AD", indices);
	checkSBI(L"\x0061\x000A", indices);
	checkSBI(L"\x0061\x000D", indices);
	checkSBI(L"\x0061\x0085", indices);
	checkSBI(L"\x0061\x0009", indices);
	checkSBI(L"\x0061\x0020", indices);
	checkSBI(L"\x0061\x0061", indices);
	checkSBI(L"\x0061\x0041", indices);
	checkSBI(L"\x0061\x00A0", indices);
	checkSBI(L"\x0061\x0030", indices);
	checkSBI(L"\x0061\x002E", indices);
	checkSBI(L"\x0061\x0021", indices);
	checkSBI(L"\x0061\x0022", indices);
	checkSBI(L"\x0041\x0023", indices);
	checkSBI(L"\x0041\x0001", indices);
	checkSBI(L"\x0041\x0300", indices);
	checkSBI(L"\x0041\x00AD", indices);
	checkSBI(L"\x0041\x000A", indices);
	checkSBI(L"\x0041\x000D", indices);
	checkSBI(L"\x0041\x0085", indices);
	checkSBI(L"\x0041\x0009", indices);
	checkSBI(L"\x0041\x0020", indices);
	checkSBI(L"\x0041\x0061", indices);
	checkSBI(L"\x0041\x0041", indices);
	checkSBI(L"\x0041\x00A0", indices);
	checkSBI(L"\x0041\x0030", indices);
	checkSBI(L"\x0041\x002E", indices);
	checkSBI(L"\x0041\x0021", indices);
	checkSBI(L"\x0041\x0022", indices);
	checkSBI(L"\x00A0\x0023", indices);
	checkSBI(L"\x00A0\x0001", indices);
	checkSBI(L"\x00A0\x0300", indices);
	checkSBI(L"\x00A0\x00AD", indices);
	checkSBI(L"\x00A0\x000A", indices);
	checkSBI(L"\x00A0\x000D", indices);
	checkSBI(L"\x00A0\x0085", indices);
	checkSBI(L"\x00A0\x0009", indices);
	checkSBI(L"\x00A0\x0020", indices);
	checkSBI(L"\x00A0\x0061", indices);
	checkSBI(L"\x00A0\x0041", indices);
	checkSBI(L"\x00A0\x00A0", indices);
	checkSBI(L"\x00A0\x0030", indices);
	checkSBI(L"\x00A0\x002E", indices);
	checkSBI(L"\x00A0\x0021", indices);
	checkSBI(L"\x00A0\x0022", indices);
	checkSBI(L"\x0030\x0023", indices);
	checkSBI(L"\x0030\x0001", indices);
	checkSBI(L"\x0030\x0300", indices);
	checkSBI(L"\x0030\x00AD", indices);
	checkSBI(L"\x0030\x000A", indices);
	checkSBI(L"\x0030\x000D", indices);
	checkSBI(L"\x0030\x0085", indices);
	checkSBI(L"\x0030\x0009", indices);
	checkSBI(L"\x0030\x0020", indices);
	checkSBI(L"\x0030\x0061", indices);
	checkSBI(L"\x0030\x0041", indices);
	checkSBI(L"\x0030\x00A0", indices);
	checkSBI(L"\x0030\x0030", indices);
	checkSBI(L"\x0030\x002E", indices);
	checkSBI(L"\x0030\x0021", indices);
	checkSBI(L"\x0030\x0022", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkSBI(L"\x002E\x0023", indices);
	checkSBI(L"\x002E\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkSBI(L"\x002E\x0300", indices);
	checkSBI(L"\x002E\x00AD", indices);
	checkSBI(L"\x002E\x000A", indices);
	checkSBI(L"\x002E\x000D", indices);
	checkSBI(L"\x002E\x0085", indices);
	checkSBI(L"\x002E\x0009", indices);
	checkSBI(L"\x002E\x0020", indices);
	checkSBI(L"\x002E\x0061", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkSBI(L"\x002E\x0041", indices);
	checkSBI(L"\x002E\x00A0", indices);
	initializeContainer(indices) = 0, 2;
	checkSBI(L"\x002E\x0030", indices);
	checkSBI(L"\x002E\x002E", indices);
	checkSBI(L"\x002E\x0021", indices);
	checkSBI(L"\x002E\x0022", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkSBI(L"\x0021\x0023", indices);
	checkSBI(L"\x0021\x0001", indices);
	initializeContainer(indices) = 0, 2;
	checkSBI(L"\x0021\x0300", indices);
	checkSBI(L"\x0021\x00AD", indices);
	checkSBI(L"\x0021\x000A", indices);
	checkSBI(L"\x0021\x000D", indices);
	checkSBI(L"\x0021\x0085", indices);
	checkSBI(L"\x0021\x0009", indices);
	checkSBI(L"\x0021\x0020", indices);
	initializeContainer(indices) = 0, 1, 2;
	checkSBI(L"\x0021\x0061", indices);
	checkSBI(L"\x0021\x0041", indices);
	checkSBI(L"\x0021\x00A0", indices);
	checkSBI(L"\x0021\x0030", indices);
	initializeContainer(indices) = 0, 2;
	checkSBI(L"\x0021\x002E", indices);
	checkSBI(L"\x0021\x0021", indices);
	checkSBI(L"\x0021\x0022", indices);
	checkSBI(L"\x0022\x0023", indices);
	checkSBI(L"\x0022\x0001", indices);
	checkSBI(L"\x0022\x0300", indices);
	checkSBI(L"\x0022\x00AD", indices);
	checkSBI(L"\x0022\x000A", indices);
	checkSBI(L"\x0022\x000D", indices);
	checkSBI(L"\x0022\x0085", indices);
	checkSBI(L"\x0022\x0009", indices);
	checkSBI(L"\x0022\x0020", indices);
	checkSBI(L"\x0022\x0061", indices);
	checkSBI(L"\x0022\x0041", indices);
	checkSBI(L"\x0022\x00A0", indices);
	checkSBI(L"\x0022\x0030", indices);
	checkSBI(L"\x0022\x002E", indices);
	checkSBI(L"\x0022\x0021", indices);
	checkSBI(L"\x0022\x0022", indices);
	initializeContainer(indices) = 0, 8, 17;
	checkSBI(L"\x0028\x0022\x0047\x006F\x002E\x0022\x0029\x0020\x0028\x0048\x0065\x0020\x0064\x0069\x0064\x002E\x0029", indices);
	checkSBI(L"\x0028\x201C\x0047\x006F\x003F\x201D\x0029\x0020\x0028\x0048\x0065\x0020\x0064\x0069\x0064\x002E\x0029", indices);
	initializeContainer(indices) = 0, 10;
	checkSBI(L"\x0055\x002E\x0053\x002E\x0041\x0300\x002E\x0020\x0069\x0073", indices);
	initializeContainer(indices) = 0, 8, 10;
	checkSBI(L"\x0055\x002E\x0053\x002E\x0041\x0300\x003F\x0020\x0048\x0065", indices);
	initializeContainer(indices) = 0, 7;
	checkSBI(L"\x0055\x002E\x0053\x002E\x0041\x0300\x002E", indices);
	initializeContainer(indices) = 0, 3;
	checkSBI(L"\x0033\x002E\x0034", indices);
	checkSBI(L"\x0063\x002E\x0064", indices);
	initializeContainer(indices) = 0, 6, 12;
	checkSBI(L"\x0065\x0074\x0063\x002E\x0029\x2019\x00A0\x2018\x0028\x0074\x0068\x0065", indices);
	checkSBI(L"\x0065\x0074\x0063\x002E\x0029\x2019\x00A0\x2018\x0028\x0054\x0068\x0065", indices);
	initializeContainer(indices) = 0, 21;
	checkSBI(L"\x0074\x0068\x0065\x0020\x0072\x0065\x0073\x0070\x002E\x0020\x006C\x0065\x0061\x0064\x0065\x0072\x0073\x0020\x0061\x0072\x0065", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkSBI(L"\x5B57\x002E\x5B57", indices);
	initializeContainer(indices) = 0, 4, 5;
	checkSBI(L"\x0065\x0074\x0063\x002E\x5B83", indices);
	initializeContainer(indices) = 0, 5;
	checkSBI(L"\x0065\x0074\x0063\x002E\x3002", indices);
	initializeContainer(indices) = 0, 2, 3;
	checkSBI(L"\x5B57\x3002\x5B83", indices);
	initializeContainer(indices) = 0, 17, 36;
	checkSBI(L"\x2060\x0028\x2060\x0022\x2060\x0047\x2060\x006F\x2060\x002E\x2060\x0022\x2060\x0029\x2060\x0020\x2060\x0028\x2060\x0048\x2060\x0065\x2060\x0020\x2060\x0064\x2060\x0069\x2060\x0064\x2060\x002E\x2060\x0029\x2060\x2060", indices);
	checkSBI(L"\x2060\x0028\x2060\x201C\x2060\x0047\x2060\x006F\x2060\x003F\x2060\x201D\x2060\x0029\x2060\x0020\x2060\x0028\x2060\x0048\x2060\x0065\x2060\x0020\x2060\x0064\x2060\x0069\x2060\x0064\x2060\x002E\x2060\x0029\x2060\x2060", indices);
	initializeContainer(indices) = 0, 21;
	checkSBI(L"\x2060\x0055\x2060\x002E\x2060\x0053\x2060\x002E\x2060\x0041\x2060\x0300\x002E\x2060\x0020\x2060\x0069\x2060\x0073\x2060\x2060", indices);
	initializeContainer(indices) = 0, 16, 21;
	checkSBI(L"\x2060\x0055\x2060\x002E\x2060\x0053\x2060\x002E\x2060\x0041\x2060\x0300\x003F\x2060\x0020\x2060\x0048\x2060\x0065\x2060\x2060", indices);
	initializeContainer(indices) = 0, 15;
	checkSBI(L"\x2060\x0055\x2060\x002E\x2060\x0053\x2060\x002E\x2060\x0041\x2060\x0300\x002E\x2060\x2060", indices);
	initializeContainer(indices) = 0, 8;
	checkSBI(L"\x2060\x0033\x2060\x002E\x2060\x0034\x2060\x2060", indices);
	checkSBI(L"\x2060\x0063\x2060\x002E\x2060\x0064\x2060\x2060", indices);
	initializeContainer(indices) = 0, 13, 26;
	checkSBI(L"\x2060\x0065\x2060\x0074\x2060\x0063\x2060\x002E\x2060\x0029\x2060\x2019\x2060\x00A0\x2060\x2018\x2060\x0028\x2060\x0074\x2060\x0068\x2060\x0065\x2060\x2060", indices);
	checkSBI(L"\x2060\x0065\x2060\x0074\x2060\x0063\x2060\x002E\x2060\x0029\x2060\x2019\x2060\x00A0\x2060\x2018\x2060\x0028\x2060\x0054\x2060\x0068\x2060\x0065\x2060\x2060", indices);
	initializeContainer(indices) = 0, 44;
	checkSBI(L"\x2060\x0074\x2060\x0068\x2060\x0065\x2060\x0020\x2060\x0072\x2060\x0065\x2060\x0073\x2060\x0070\x2060\x002E\x2060\x0020\x2060\x006C\x2060\x0065\x2060\x0061\x2060\x0064\x2060\x0065\x2060\x0072\x2060\x0073\x2060\x0020\x2060\x0061\x2060\x0072\x2060\x0065\x2060\x2060", indices);
	initializeContainer(indices) = 0, 5, 8;
	checkSBI(L"\x2060\x5B57\x2060\x002E\x2060\x5B57\x2060\x2060", indices);
	initializeContainer(indices) = 0, 9, 12;
	checkSBI(L"\x2060\x0065\x2060\x0074\x2060\x0063\x2060\x002E\x2060\x5B83\x2060\x2060", indices);
	initializeContainer(indices) = 0, 12;
	checkSBI(L"\x2060\x0065\x2060\x0074\x2060\x0063\x2060\x002E\x2060\x3002\x2060\x2060", indices);
	initializeContainer(indices) = 0, 5, 8;
	checkSBI(L"\x2060\x5B57\x2060\x3002\x2060\x5B83\x2060\x2060", indices);
}

int test_main(int, char*[]) {
	boost::unit_test::test_suite* test = BOOST_TEST_SUITE("Break iterator test");
	test->add(BOOST_TEST_CASE(&testGraphemeBreakIterator));
	test->add(BOOST_TEST_CASE(&testWordBreakIterator));
	test->add(BOOST_TEST_CASE(&testSentenceBreakIterator));
	return 0;
}
