/*
 *  MDUtility.h
 *
 *  Created by Toshi Nagata on Sun Jun 17 2001.

   Copyright (c) 2000-2011 Toshi Nagata. All rights reserved.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation version 2 of the License.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 */

#ifndef __MDUtility__
#define __MDUtility__

typedef struct MDArray	MDArray;

#ifndef __MDCommon__
#include "MDCommon.h"
#endif

struct MDArray {
	long			refCount;	/*  the reference count  */
	long			num;		/*  the number of elements  */
	long			maxIndex;	/*  the number of allocated elements  */
	long			elemSize;	/*  the size of the element  */
	long			pageSize;	/*  the page size  */
	void *			data;		/*  data */
	char			allocated;	/*  non-zero if data is allocated by malloc()  */
	void			(*destructor)(void *);	/*  element destructor  */
};

#define kMDArrayDefaultPageSize	16

#ifdef __cplusplus
extern "C" {
#endif

/* -------------------------------------------------------------------
    MDUtility functions
   -------------------------------------------------------------------  */

/* Xg[lǂݏoBANSI-C  scanf ƎĂ邪AtH[}bg
   Perl  pack/unpack tH[}bg̃TuZbgƂȂĂAu^w蕶 [JEg]v
   ̕тƂȂĂiJEg͏ȗ\jB^w蕶 a, A, c, C, n, N, w 
   T|[gĂBɂ́Aw肳ꂽ^̕ϐւ̃|C^ɕׂB
   a, A ̏ꍇ̓JEg "*" włȀꍇ long ^ϐPǂݎ
   JEgƂ݂ȂBȊȌꍇ̓JEg͒萔łȂ΂ȂȂB */
long	MDReadStreamFormat(STREAM stream, const char *format, ...);

/* Xg[ɒloBtH[}bg MDReadStreamFormat() ƓB */
long	MDWriteStreamFormat(STREAM stream, const char *format, ...);

/* t@CXg[JB fopen() ƓBԂ|C^ STREAM ^
   |C^ƂāA}N PUTC, GETC,... ȂǂƂƂɎgƂłB */
STREAM	MDStreamOpenFile(const char *fname, const char *mode);

/* f[^Xg[JBptr  NULL Amalloc() Ŋmۂf[^|C^łȂ
   ȂȂBsize ̓f[^TCYŁAptr == NULL ̏ꍇ 0 nƁB
   ӁFFCLOSE(stream)  ptr ͉ꂸAstream BāA
   FCLOSE ̑O MDStreamGetData() Ńf[^|C^ƃTCY擾ĂȂ΂ȂȂB */
STREAM	MDStreamOpenData(void *ptr, size_t size);

/* f[^Xg[݂̌̃f[^|C^ƃf[^TCYԂBXg[f[^Xg[
   Ȃꍇ -1 ԂB */
int     MDStreamGetData(STREAM stream, void **ptr, size_t *size);

/* -------------------------------------------------------------------
    Debug print functions
   -------------------------------------------------------------------  */
#if DEBUG
/*  Control output of debugging messages  */
extern int gMDVerbose;
int		_dprintf(const char *fname, int lineno, int level, const char *fmt, ...);
#endif

#if DEBUG
/*  Usage: dprintf(int level, const char *fmt, ...)  */
#define dprintf(level, fmt...) (gMDVerbose >= (level) ? _dprintf(__FILE__, __LINE__, (level), fmt) : 0)
#else
#define dprintf(level, fmt...) ((void)0)
#endif

/* -------------------------------------------------------------------
    MDArray functions
   -------------------------------------------------------------------  */

/*  V MDArray AP[gBs̏ꍇ NULL ԂB 
    elementSize ͗vfP̃oCgApageSize ̓mۂPʁivfj */
MDArray *	MDArrayNew(long elementSize);
MDArray *	MDArrayNewWithPageSize(long elementSize, long pageSize);

MDArray *	MDArrayNewWithDestructor(long elementSize, void (*destruct)(void *));

/*  łɃAP[gĂ郁 MDArray B */
MDArray *	MDArrayInit(MDArray *arrayRef, long elementSize);
MDArray *	MDArrayInitWithPageSize(MDArray *arrayRef, long elementSize, long pageSize);

/*  MDArray  retain/releaseB */
void		MDArrayRetain(MDArray *arrayRef);
void		MDArrayRelease(MDArray *arrayRef);

/*  MDArray ̒Oɂ  */
void		MDArrayEmpty(MDArray *arrayRef);

/*  vf̐Ԃ  */
long		MDArrayCount(const MDArray *arrayRef);

/*  MDArray ̗vfύXBinCount ݂̗vf葽΁AȂ͂ONABinCount ݂̗vf菭Ȃ΁AZȂ͖قĎ̂ĂB */
MDStatus    MDArraySetCount(MDArray *arrayRef, long inCount);

/*  inIndex Ԗځi擪Oj inLength vf}BKvȂ玩I
    mۂAԂɌ̗vf΂ONAB  */
MDStatus	MDArrayInsert(MDArray *arrayRef, long inIndex, long inLength, const void *inData);

/*  inIndex Ԗځi擪Oj inLength vf폜  */
MDStatus	MDArrayDelete(MDArray *arrayRef, long inIndex, long inLength);

/*  inIndex Ԗځi擪Oj inLength ̗vf inData ŒuBKvȂ
    IɃmۂAԂɌ̗vf΂ONAB */
MDStatus	MDArrayReplace(MDArray *arrayRef, long inIndex, long inLength, const void *inData);

/*  inIndex Ԗځi擪Oj inLength ̗vf outData ɎoB
    ۂɎoꂽvf̐ԂB */
long		MDArrayFetch(const MDArray *arrayRef, long inIndex, long inLength, void *outData);

void *		MDArrayFetchPtr(const MDArray *arrayRef, long inIndex);

#ifdef __cplusplus
}
#endif

#endif  /*  __MDUtility__  */
