//
//  i18n.h
//  Afficheur
//
//  Created by kichi on 09/03/09.
//  Copyright 2009,2010 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface i18n : NSObject {

}

// Rate limit of Twitter
APPKIT_EXTERN NSString* i18nWarning;
APPKIT_EXTERN NSString* i18nRateLimit;
APPKIT_EXTERN NSString* i18nWarningRateLimit;

// Emoji
APPKIT_EXTERN NSString* i18nEmoji;
APPKIT_EXTERN NSString* i18nEmojiDocomo;
APPKIT_EXTERN NSString* i18nEmojiAu;
APPKIT_EXTERN NSString* i18nEmojiSoftBank;
APPKIT_EXTERN NSString* i18nEmojiJaiku;
APPKIT_EXTERN NSString* i18nClearJaikuIcon;

// IM
APPKIT_EXTERN NSString*	i18nIM;

// Grab
APPKIT_EXTERN NSString*	i18nSafari;
APPKIT_EXTERN NSString*	i18nFirefox;
APPKIT_EXTERN NSString*	i18nChrome;
APPKIT_EXTERN NSString*	i18nChromium;
APPKIT_EXTERN NSString*	i18nITunes;

// Preferences
APPKIT_EXTERN NSString* i18nNeverInterval;
APPKIT_EXTERN NSString* i18n60seconds;
APPKIT_EXTERN NSString* i18n90seconds;
APPKIT_EXTERN NSString* i18n2minutes;
APPKIT_EXTERN NSString* i18n3minutes;
APPKIT_EXTERN NSString* i18n5minutes;
APPKIT_EXTERN NSString* i18n10minutes;
APPKIT_EXTERN NSString* i18n15minutes;
APPKIT_EXTERN NSString* i18n30minutes;
APPKIT_EXTERN NSString* i18n60minutes;

APPKIT_EXTERN NSString* i18nGeneral;
APPKIT_EXTERN NSString* i18nHotKey;
APPKIT_EXTERN NSString* i18nAccount;
APPKIT_EXTERN NSString* i18nKeywords;
APPKIT_EXTERN NSString* i18nSuggestions;
APPKIT_EXTERN NSString* i18nAppearances;

APPKIT_EXTERN NSString* i18nAPIKey;

APPKIT_EXTERN NSString* i18nAuthorize;
APPKIT_EXTERN NSString* i18nRemove;

APPKIT_EXTERN NSString* i18nRemoveToken;

APPKIT_EXTERN NSString* i18nPleaseTwitterAuthorize;
APPKIT_EXTERN NSString* i18nPleaseJaikuAuthorize;
APPKIT_EXTERN NSString* i18nPleaseTumblrAuthorize;
APPKIT_EXTERN NSString* i18nPleaseFriendFeedAuthorize;
APPKIT_EXTERN NSString* i18nPleaseFaceBookAuthorize;

// Predicate
APPKIT_EXTERN NSString* i18nFilterService;
APPKIT_EXTERN NSString* i18nFilterChannel;
APPKIT_EXTERN NSString* i18nFilterUser;
APPKIT_EXTERN NSString* i18nFilterThread;
APPKIT_EXTERN NSString* i18nFiltersIn;
APPKIT_EXTERN NSString* i18nReleaseFilters;

// MACROs

#define WARNING						NSLocalizedString(i18nWarning, @"")
#define RATE_LIMIT					NSLocalizedString(i18nRateLimit, @"")
#define WARNING_RATE_LIMIT			NSLocalizedString(i18nWarningRateLimit, @"")

#define EMOJI						NSLocalizedString(i18nEmoji, @"")
#define DOCOMO						NSLocalizedString(i18nEmojiDocomo, @"")
#define AU							NSLocalizedString(i18nEmojiAu, @"")
#define SOFTBANK					NSLocalizedString(i18nEmojiSoftBank, @"")
#define JAIKU						NSLocalizedString(i18nEmojiJaiku, @"")
#define CLEAR_JAIKU_ICON			NSLocalizedString(i18nClearJaikuIcon, @"")

#define IM							NSLocalizedString(i18nIM, @"")

#define SAFARI						NSLocalizedString(i18nSafari, @"")
#define FIREFOX						NSLocalizedString(i18nFirefox, @"")
#define CHROME						NSLocalizedString(i18nChrome, @"")
#define CHROMIUM					NSLocalizedString(i18nChromium, @"")
#define ITUNES						NSLocalizedString(i18nITunes, @"")

#define NEVER_INTERVAL				NSLocalizedString(i18nNeverInterval, @"")
#define SEC60						NSLocalizedString(i18n60seconds, @"")
#define SEC90						NSLocalizedString(i18n90seconds, @"")
#define MIN2						NSLocalizedString(i18n2minutes, @"")
#define MIN3						NSLocalizedString(i18n3minutes, @"")
#define MIN5						NSLocalizedString(i18n5minutes, @"")
#define MIN10						NSLocalizedString(i18n10minutes, @"")
#define MIN15						NSLocalizedString(i18n15minutes, @"")
#define MIN30						NSLocalizedString(i18n30minutes, @"")
#define MIN60						NSLocalizedString(i18n60minutes, @"")

#define GENERAL						NSLocalizedString(i18nGeneral, @"")
#define HOTKEY						NSLocalizedString(i18nHotKey, @"")
#define ACCOUNT						NSLocalizedString(i18nAccount, @"")
#define KEYWORDS					NSLocalizedString(i18nKeywords, @"")
#define SUGGESTION					NSLocalizedString(i18nSuggestions, @"")
#define APPEARANCES					NSLocalizedString(i18nAppearances, @"")

#define API_KEY						NSLocalizedString(i18nAPIKey, @"")

#define AUTHORIZE					NSLocalizedString(i18nAuthorize, @"")
#define REMOVE						NSLocalizedString(i18nRemove, @"")

#define REMOVE_TOKEN				NSLocalizedString(i18nRemoveToken, @"")

#define PLEASE_TWITTER_AUTHORIZE	NSLocalizedString(i18nPleaseTwitterAuthorize, @"")
#define PLEASE_JAIKU_AUTHORIZE		NSLocalizedString(i18nPleaseJaikuAuthorize, @"")
#define PLEASE_TUMBLR_AUTHORIZE		NSLocalizedString(i18nPleaseTumblrAuthorize, @"")
#define PLEASE_FRIENDFEED_AUTHORIZE	NSLocalizedString(i18nPleaseFriendFeedAuthorize, @"")
#define PLEASE_FACEBOOK_AUTHORIZE	NSLocalizedString(i18nPleaseFaceBookAuthorize, @"")

#define FILTER_SERVICE				NSLocalizedString(i18nFilterService, @"")
#define FILTER_CHANNEL				NSLocalizedString(i18nFilterChannel, @"")
#define FILTER_USER					NSLocalizedString(i18nFilterUser, @"")
#define FILTER_THREAD				NSLocalizedString(i18nFilterThread, @"")
#define FILTERS_IN					NSLocalizedString(i18nFiltersIn, @"")
#define RELEASE_FILTERS				NSLocalizedString(i18nReleaseFilters, @"")

@end
