//
//  TableView.m
//  Afficheur
//
//  Created by kichi on 09/03/19.
//  Copyright 2009 Katsuhiko Ichinose. All rights reserved.
//

#import "TableView.h"


@implementation TableView

- (void)keyUp:(NSEvent *)theEvent
{
	[super mouseMoved:theEvent];
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(tableView:keyUp:)])
	{
		[delegate performSelector:@selector(tableView:keyUp:)
					   withObject:self
					   withObject:theEvent];
	}
}

- (void)mouseMoved:(NSEvent *)theEvent
{
	[super mouseMoved:theEvent];
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(tableView:mouseMoved:)])
	{
		[delegate performSelector:@selector(tableView:mouseMoved:)
					   withObject:self
					   withObject:theEvent];
	}
}

- (void)flagsChanged:(NSEvent *)theEvent
{
	[super flagsChanged:theEvent];
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(tableView:flagsChanged:)])
	{
		[delegate performSelector:@selector(tableView:flagsChanged:)
					   withObject:self
					   withObject:theEvent];
	}
}

- (void)scrollWheel:(NSEvent *)theEvent
{
	[super scrollWheel:theEvent];
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(tableView:scrollWheel:)])
	{
		[delegate performSelector:@selector(tableView:scrollWheel:)
					   withObject:self
					   withObject:theEvent];
	}
}

@end
