//
//  ServiceTwitter.h
//  Afficheur
//
//  Created by kichi on 08/09/02.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "Service.h"
#import "TwitterAPI.h"


@interface ServiceTwitter : Service {
	NSString*			_notify;
	NSString*			_notifyReply;
	NSString*			_notifyDM;
	NSString*			_notifyError;
//	NSMutableArray*		_since;

	NSDate*				_dateTimeline;
	NSDate*				_dateReplies;
	NSDate*				_dateDM;

	BOOL				_first;
	BOOL				_firstReplies;
	BOOL				_firstDM;
	int					_tweets;
	int					_keepTweets;

	NSString*			_request_token;
	NSString*			_request_token_secret;
	NSString*			_access_token;
	NSString*			_access_token_secret;
	
	TwitterAPI*			_stream;
	NSLock*				_lock;
}

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (void)setRequestToken:(NSString *)requestToken;
- (void)setRequestTokenSecret:(NSString *)requestTokenSecret;
- (void)setAccessToken:(NSString *)accessToken;
- (void)setAccessTokenSecret:(NSString *)accessTokenSecret;

- (NSString *)authorize;
- (BOOL)access_token:(NSString *)pin;
- (NSString *)accessToken;
- (NSString *)accessTokenSecret;

- (void)setupRetrieveDate:(NSDate *)date;
- (void)setupRetrieveDateTimeline:(NSDate *)date;
- (void)setupRetrieveDateReplies:(NSDate *)date;
- (void)setupRetrieveDateDM:(NSDate *)date;

- (BOOL)checkRetrieve:(NSDate *)now
			 withDate:(NSDate *)date
			 interval:(NSTimeInterval)interval;

- (BOOL)checkRetrieveTimeline:(NSDate *)now;
- (BOOL)checkRetrieveReplies:(NSDate *)now;
- (BOOL)checkRetrieveDM:(NSDate *)now;

- (TwitterAPI *)createAPI:(NSDictionary *)dic;

- (NSString *)determinePost:(id)object
					withAPI:(TwitterAPI *)api
				   function:(NSString *)function
					   post:(NSString *)post;

- (NSString *)determinePost:(id)object
					withAPI:(TwitterAPI *)api
				   function:(NSString *)function;

- (int)rateLimit;

//- (NSString *)since;

- (void)performPost:(NSArray *)array;
- (void)performDirectMessage:(NSArray *)array;

- (void)post:(NSString *)status
   withReply:(NSString *)reply;

- (void)performRetrieve:(TwitterAPI *)api
			 withObject:(id)object
				   kind:(int)kind
				  first:(BOOL)first;

- (void)performRetrieveTimeline:(NSDictionary *)dic;
- (void)performRetrieveHomeTimeline:(NSDictionary *)dic;
- (void)performRetrieveReplies:(NSDictionary *)dic;
- (void)performRetrieveDirectMessage:(NSDictionary *)dic;
- (void)performFavorite:(NSArray *)object;
- (void)performRetweetViaAPI:(NSArray *)object;

- (void)retrieveTimeline;
- (void)retrieveReplies;
- (void)retrieveDirectMessage;

- (void)favorite:(NSString *)item_id;

- (NSString *)permalinkURL:(NSString *)item_id;
- (void)permalink:(NSString *)item_id;

- (BOOL)userStream;
- (void)closeStream;
- (BOOL)isStream;

- (void)receiveStream:(id)userStream;
- (void)finishStream;
- (void)errorStream:(NSError *)error;

@end
