//
//  ServiceJisko.h
//  Afficheur
//
//  Created by kichi on 08/10/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ServiceTwitter.h"

@class ServiceXMPP;

@interface ServiceJisko : ServiceTwitter {
	NSMutableDictionary*	_userProfile;

}

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (void)setupXMPP:(ServiceXMPP *)xmpp;

- (BOOL)checkRetrieveTimeline:(NSDate *)now;
- (BOOL)checkRetrieveReplies:(NSDate *)now;
- (BOOL)checkRetrieveDM:(NSDate *)now;

- (void)post:(NSString *)status
   withReply:(NSString *)reply;

- (void)retrieveTimeline;
- (void)retrieveReplies;
- (void)retrieveDirectMessage;

- (void)doReply:(NSString *)item_id;

- (void)favorite:(NSString *)item_id;

- (void)permalink:(NSString *)item_id;

@end
