//
//  AfficheurPreferences.h
//  Afficheur
//
//  Created by kichi on 08/04/05.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class WebView;
@class KeyEquivView;
@class AfficheurController;
@class AfficheurTimeline;


@interface AfficheurPreferences : NSObject {
	IBOutlet id				_panel;
	IBOutlet id				_viewNil;
	IBOutlet id				_viewGeneral;
	IBOutlet id				_tokenBrowser;
	IBOutlet id				_tokenITunes;
	IBOutlet id				_viewHotKeys;
	IBOutlet id				_viewAccount;
	IBOutlet id				_tableAccount;
	IBOutlet id				_boxAccount;
	IBOutlet id				_arrayAccount;
	IBOutlet id				_viewTwitter;
	IBOutlet id				_viewJaiku;
	IBOutlet id				_viewTumblr;
//	IBOutlet id				_viewNowa;
	IBOutlet id				_viewWassr;
	IBOutlet id				_viewIdentica;
//	IBOutlet id				_viewJisko;
//	IBOutlet id				_viewChuitter;
	IBOutlet id				_viewFriendFeed;
	IBOutlet id				_viewFaceBook;
	IBOutlet id				_viewBitLy;
	IBOutlet id				_viewKeyword;
	IBOutlet id				_viewSuggestion;
	IBOutlet id				_arrayKeywords;
	IBOutlet id				_arrayIgnoreKeywords;
	IBOutlet id				_arraySuggestions;
	IBOutlet id				_arrayIgnores;
	IBOutlet id				_tableSuggestions;
	IBOutlet id				_tableIgnores;
	IBOutlet id				_popupIntervalTimeline;
	IBOutlet id				_popupIntervalReplies;
	IBOutlet id				_popupIntervalDM;
	IBOutlet id				_labelRequests;
	IBOutlet id				_label;
//	IBOutlet id				_jaikuAPI;
//	IBOutlet id				_nowaAPI;
//	IBOutlet id				_jiskoAPI;
	IBOutlet id				_textFieldPost;
	IBOutlet id				_textFieldTimeline;
	IBOutlet id				_viewAppearance;
	IBOutlet id				_btnAppearanceUser;
	IBOutlet id				_btnAppearanceText;
	IBOutlet id				_btnAppearanceComment;
	IBOutlet id				_btnAppearanceDate;
	IBOutlet id				_btnAppearanceColorUser;
	IBOutlet id				_btnAppearanceColorText;
	IBOutlet id				_btnAppearanceColorComment;
	IBOutlet id				_btnAppearanceColorDate;
	IBOutlet id				_btnAppearanceColorBackground;
	IBOutlet id				_btnAppearanceReplyUser;
	IBOutlet id				_btnAppearanceReplyText;
	IBOutlet id				_btnAppearanceReplyComment;
	IBOutlet id				_btnAppearanceReplyDate;
	IBOutlet id				_btnAppearanceReplyBackground;
	IBOutlet id				_btnAppearanceChannelUser;
	IBOutlet id				_btnAppearanceChannelText;
	IBOutlet id				_btnAppearanceChannelComment;
	IBOutlet id				_btnAppearanceChannelDate;
	IBOutlet id				_btnAppearanceChannelBackground;
	IBOutlet id				_btnAppearanceMessageUser;
	IBOutlet id				_btnAppearanceMessageText;
	IBOutlet id				_btnAppearanceMessageComment;
	IBOutlet id				_btnAppearanceMessageDate;
	IBOutlet id				_btnAppearanceMessageBackground;
	IBOutlet id				_btnAppearanceKeywordUser;
	IBOutlet id				_btnAppearanceKeywordText;
	IBOutlet id				_btnAppearanceKeywordComment;
	IBOutlet id				_btnAppearanceKeywordDate;
	IBOutlet id				_btnAppearanceKeywordBackground;
	IBOutlet id				_tableTimeline;
	IBOutlet id				_arrayTimeline;
	IBOutlet id				_panelWeb;
	IBOutlet WebView*		_webView;
	IBOutlet id				_webOK;
	IBOutlet id				_textJaikuToken;
	IBOutlet id				_textTwitterToken;
	IBOutlet id				_textTumblrToken;
	IBOutlet id				_textFriendFeedToken;
	IBOutlet id				_textFaceBookUser;
	IBOutlet id				_textFaceBookToken;
	IBOutlet id				_btnJaikuAuthorize;
	IBOutlet id				_btnTwitterAuthorize;
	IBOutlet id				_btnTumblrAuthorize;
	IBOutlet id				_btnFriendFeedAuthorize;
	IBOutlet id				_btnFaceBookAuthorize;
	IBOutlet id				_textPleaseAuthorize;
	IBOutlet id				_panelConfirm;
	IBOutlet id				_textConfirm;
	IBOutlet id				_tableKeyword;
	IBOutlet id				_panelKeyword;
	IBOutlet id				_dicRule;
	IBOutlet id				_arrayRule;
	IBOutlet id				_tableRule;

	AfficheurController*	_controller;
	AfficheurTimeline*		_timeline;
	NSTableColumn*			_columnText;
	NSTableColumn*			_columnDate;
	
	NSArray*				_arrayBrowser;
	NSArray*				_arrayITunes;
	
	NSArray*				_accounts;
	NSDictionary*			_appearances;
	NSDictionary*			_localAppearances;
	NSDictionary*			_appearanceButtons;
	id						_currentAppearance;
	NSDictionary*			_appearanceColorButtons;

	NSDictionary*			_intervalTable;
	NSDictionary*			_intervalIndexes;
	NSArray*				_intervals;
	NSDictionary*			_retrieveTable;
	NSArray*				_retrieves;
	NSDictionary*			_keyMask;
	NSArray*				_timelineLimits;

	int						_rateLimit;
	BOOL					_openColorPanel;
	
	BOOL					_openFirst;
	NSToolbar*				_panelToolBar;
	NSString*				_currentItem;

	KeyEquivView*			_keyEquivViewPost;
	KeyEquivView*			_keyEquivViewTimeline;
	
	id						_target;

	NSString*				_enabledURL;
	BOOL					_useEmoji;
}

enum {
	PostToEnter = 0,
	PostToControlEnter,
	PostToOptionEnter,
	PostToShiftEnter,
	PostToControlShiftEnter,
	PostToOptionShiftEnter,
};

enum {
	ClearAfterPostNever = 0,
	ClearAfterPostReply,
	ClearAfterPostAllways,
};

- (void)setTimeline:(AfficheurTimeline *)timeline;
- (void)setController:(AfficheurController *)controller;

- (NSString *)frameMain;
- (NSString *)frameTimeline;

- (BOOL)postTwitter;
- (BOOL)postJaiku;
- (BOOL)postTumblr;
- (BOOL)postWassr;
//- (BOOL)postNowa;
- (BOOL)postIdentica;
//- (BOOL)postJisko;
//- (BOOL)postChuitter;
- (BOOL)postFriendFeed;
- (BOOL)postFaceBook;

- (BOOL)timelineVisibleToolbar;
- (void)timelineSetVisibleToolbar:(BOOL)visible;

- (BOOL)generalDockIcon;
- (BOOL)generalStatusMenuIcon;
- (int)generalMenuIcon;
- (BOOL)generalStartAtLogin;
- (BOOL)generalUseGrowl;
- (BOOL)generalEncodeTinyURL;
- (BOOL)generalGrabURL;
- (NSString *)generalTextURL;
- (BOOL)generalGrabURLwithClipboard;
- (BOOL)generalGrabITunes;
- (NSString *)generalTextITunes;
- (BOOL)generalRetrieveWhenReply;
- (BOOL)generalInlineImage;
- (BOOL)generalExtractTinyURL;
- (BOOL)generalDeleteAfterReply;
- (int)generalClearAfterPost;
- (BOOL)generalKeepSelectedItem;
- (BOOL)generalNotKeepTimeline;
- (BOOL)generalKeepCursorPosition;
- (void)setGeneralKeepCursorPosition:(BOOL)value;
- (BOOL)generalStackTimeline;
- (BOOL)generalHideAfterPost;
- (BOOL)generalConvertEmoji;
- (BOOL)generalGrowlOldOrder;
- (BOOL)generalUseEmoji;
- (BOOL)generalIndicateSource;
- (BOOL)generalGrowlDate;
- (UInt32)generalLimitOfTimeline;
- (BOOL)generalHideStartup;
- (BOOL)generalAdjustPanel;

- (UInt32)generalHotKey;
- (UInt32)generalHotKeyTimeline;
- (int)generalPostTo;
- (int)generalPostToALT;
- (UInt32)generalReplyKeyMask;
- (UInt32)generalFavoriteKeyMask;
- (UInt32)generalPermalinkKeyMask;
- (UInt32)generalURLKeyMask;
- (UInt32)generalRetweetKeyMask;
- (UInt32)generalDirectMessageKeyMask;

- (NSString *)accountTwitterUser;
- (NSString *)accountTwitterPass;
- (BOOL)accountTwitterExecMenu;
- (BOOL)accountTwitterUseStream;
- (NSTimeInterval)accountTwitterIntervalTimeline;
- (NSTimeInterval)accountTwitterIntervalReplies;
- (NSTimeInterval)accountTwitterIntervalDM;
- (NSString *)accountTwitterOAuthKey;
- (NSString *)accountTwitterOAuthSecret;
- (BOOL)isTweetsMania;
- (int)tweetsAccountTwitterRetrieveTweets;
- (int)tweetsMaxAccountTwitterRetrieveTweets;
- (int)tweetsMinAccountTwitterRetrieveTweets;
- (void)setTweetsMinAccountTwitterRetrieveTweets:(int)tweets;
- (int)tweetsIncAccountTwitterRetrieveTweets;
- (int)tweetsDecAccountTwitterRetrieveTweets;
- (int)tweetsUpAccountTwitterRetrieveTweets;
- (int)tweetsDownAccountTwitterRetrieveTweets;
- (int)tweetsKeepAccountTwitterRetrieveTweets;
- (NSString *)accountJaikuUser;
- (NSString *)accountJaikuLocation;
- (BOOL)accountJaikuExecMenu;
- (NSTimeInterval)accountJaikuIntervalTimeline;
- (BOOL)accountJaikuUseXMPP;
- (NSString *)accountJaikuJidXMPP;
- (NSString *)accountJaikuPassXMPP;
- (NSString *)accountJaikuServerXMPP;
- (int)accountJaikuPortXMPP;
- (int)accountJaikuRetrieveXMPP;
- (BOOL)accountJaikuOfflineXMPP;
- (BOOL)accountJaikuPostXMPP;
- (NSString *)accountJaikuOAuthKey;
- (NSString *)accountJaikuOAuthSecret;
- (NSString *)accountTumblrUser;
- (NSString *)accountTumblrPass;
- (BOOL)accountTumblrExecMenu;
- (NSTimeInterval)accountTumblrIntervalTimeline;
- (NSString *)accountTumblrOAuthKey;
- (NSString *)accountTumblrOAuthSecret;
- (NSString *)accountWassrUser;
- (NSString *)accountWassrPass;
- (BOOL)accountWassrExecMenu;
- (NSTimeInterval)accountWassrIntervalTimeline;
- (NSTimeInterval)accountWassrIntervalReplies;
- (NSTimeInterval)accountWassrIntervalChannel;
- (BOOL)accountWassrUseXMPP;
- (NSString *)accountWassrJidXMPP;
- (NSString *)accountWassrPassXMPP;
- (NSString *)accountWassrServerXMPP;
- (int)accountWassrPortXMPP;
- (int)accountWassrRetrieveXMPP;
- (BOOL)accountWassrOfflineXMPP;
- (BOOL)accountWassrPostXMPP;
//- (NSString *)accountNowaUser;
//- (NSString *)accountNowaPass;
//- (BOOL)accountNowaExecMenu;
//- (NSTimeInterval)accountNowaIntervalTimeline;
- (NSString *)accountIdenticaUser;
- (NSString *)accountIdenticaPass;
- (BOOL)accountIdenticaExecMenu;
- (NSTimeInterval)accountIdenticaIntervalTimeline;
- (NSTimeInterval)accountIdenticaIntervalReplies;
- (NSTimeInterval)accountIdenticaIntervalDM;
- (BOOL)accountIdenticaUseXMPP;
- (NSString *)accountIdenticaJidXMPP;
- (NSString *)accountIdenticaPassXMPP;
- (NSString *)accountIdenticaServerXMPP;
- (int)accountIdenticaPortXMPP;
- (int)accountIdenticaRetrieveXMPP;
- (BOOL)accountIdenticaOfflineXMPP;
- (BOOL)accountIdenticaPostXMPP;
//- (NSString *)accountJiskoUser;
//- (NSString *)accountJiskoPass;
//- (BOOL)accountJiskoExecMenu;
//- (NSTimeInterval)accountJiskoIntervalTimeline;
//- (NSTimeInterval)accountJiskoIntervalReplies;
//- (NSTimeInterval)accountJiskoIntervalDM;
//- (BOOL)accountJiskoUseXMPP;
//- (NSString *)accountJiskoJidXMPP;
//- (NSString *)accountJiskoPassXMPP;
//- (NSString *)accountJiskoServerXMPP;
//- (int)accountJiskoPortXMPP;
//- (int)accountJiskoRetrieveXMPP;
//- (BOOL)accountJiskoOfflineXMPP;
//- (BOOL)accountJiskoPostXMPP;
//- (NSString *)accountChuitterUser;
//- (NSString *)accountChuitterPass;
//- (BOOL)accountChuitterExecMenu;
//- (NSTimeInterval)accountChuitterIntervalTimeline;
//- (NSTimeInterval)accountChuitterIntervalReplies;
//- (NSTimeInterval)accountChuitterIntervalDM;
//- (BOOL)accountChuitterUseXMPP;
//- (NSString *)accountChuitterJidXMPP;
//- (NSString *)accountChuitterPassXMPP;
//- (NSString *)accountChuitterServerXMPP;
//- (int)accountChuitterPortXMPP;
//- (int)accountChuitterRetrieveXMPP;
//- (BOOL)accountChuitterOfflineXMPP;
//- (BOOL)accountChuitterPostXMPP;
- (NSString *)accountFriendFeedUser;
- (NSString *)accountFriendFeedPass;
- (BOOL)accountFriendFeedExecMenu;
- (NSTimeInterval)accountFriendFeedIntervalTimeline;
//- (BOOL)accountFriendFeedUseXMPP;
//- (NSString *)accountFriendFeedJidXMPP;
//- (NSString *)accountFriendFeedPassXMPP;
//- (NSString *)accountFriendFeedServerXMPP;
//- (int)accountFriendFeedPortXMPP;
//- (int)accountFriendFeedRetrieveXMPP;
//- (BOOL)accountFriendFeedOfflineXMPP;
//- (BOOL)accountFriendFeedPostXMPP;
- (NSString *)accountFriendFeedOAuthKey;
- (NSString *)accountFriendFeedOAuthSecret;
- (NSString *)accountFaceBookId;
- (NSString *)accountFaceBookUser;
- (BOOL)accountFaceBookExecMenu;
- (NSTimeInterval)accountFaceBookIntervalTimeline;
- (NSString *)accountFaceBookOAuthToken;
- (NSString *)accountBitLyUser;
- (NSString *)accountBitLyAPIKey;
- (int)accountBitLyService;

- (NSArray *)keywords;
- (NSArray *)ignoreKeywords;

- (NSArray *)complete;
- (BOOL)addComplete:(NSString *)complete;

- (NSDictionary *)appearances;

- (void)applicationDidFinishLaunching;
- (void)applicationWillTerminate;

- (void)doDialogWithWindow:(NSWindow *)window
				  selector:(SEL)selector
					target:(id)target;

- (IBAction)onOK:(id)sender;
- (IBAction)onCancel:(id)sender;
- (IBAction)onClearPost:(id)sender;
- (IBAction)onClearTimeline:(id)sender;
- (IBAction)onMenuIcon:(id)sender;
- (IBAction)onMenuIconAlternate:(id)sender;
- (IBAction)onAppearanceFont:(id)sender;
- (IBAction)onAppearanceColor:(id)sender;

- (IBAction)onPopupInterval:(id)sender;

- (IBAction)onJaikuAuthorize:(id)sender;
- (IBAction)onTwitterAuthorize:(id)sender;
- (IBAction)onTumblrAuthorize:(id)sender;
- (IBAction)onFriendFeedAuthorize:(id)sender;
- (IBAction)onFaceBookAuthorize:(id)sender;

- (IBAction)onWebOK:(id)sender;
- (IBAction)onWebCancel:(id)sender;

- (IBAction)onConfirmOK:(id)sender;
- (IBAction)onConfirmCancel:(id)sender;

- (IBAction)onKeywordAdd:(id)sender;
- (IBAction)onKeywordDoubleClicked:(id)sender;
- (IBAction)onKeywordOK:(id)sender;
- (IBAction)onKeywordCancel:(id)sender;

@end

APPKIT_EXTERN NSString*	AppearanceFont;
APPKIT_EXTERN NSString*	AppearanceColor;
APPKIT_EXTERN NSString*	AppearanceNormal;
APPKIT_EXTERN NSString*	AppearanceReply;
APPKIT_EXTERN NSString*	AppearanceChannel;
APPKIT_EXTERN NSString*	AppearanceMessage;
APPKIT_EXTERN NSString*	AppearanceKeyword;
APPKIT_EXTERN NSString*	AppearanceUser;
APPKIT_EXTERN NSString*	AppearanceText;
APPKIT_EXTERN NSString*	AppearanceComment;
APPKIT_EXTERN NSString*	AppearanceDate;
APPKIT_EXTERN NSString*	AppearanceBackground;

APPKIT_EXTERN NSString*	InitGeneralTextURL;
APPKIT_EXTERN NSString*	InitGeneralTextITunes;

APPKIT_EXTERN NSString*	FrameMain;
APPKIT_EXTERN NSString*	FrameTimeline;

APPKIT_EXTERN BOOL HUDTimelineWindow;

