<?php
/**
 * ソースをPharにパッケージング
 *
 *
 *
 *
 *
 */
class Build
{
	private static $phar_path;
	private static $src_dir;
	private static $debug;

	/**
	 * 結果を表示して終了
	 * @access	private
	 * @static
	 * @param	Phar	$phar
	 * @return	void
	 */
	private static function finish (Phar $phar)
	{
		$val = $phar->getSignature();
		printf("\n----------------------------------------------------------------------\n\n");
		printf(" Signature   : %s (%s)\n", $val["hash"], $val["hash_type"]);
		printf(" API Version : %s\n", $phar->apiVersion());
		printf("\n----------------------------------------------------------------------\n\n");
		exit(0);
	}

	/**
	 * エラーを表示して終了
	 * @access	public
	 * @static
	 * @param	Exception	$e
	 * @return	void
	 */
	public static function error (Exception $e)
	{
		var_dump($e);
		exit(1);
	}

	/**
	 * ファイルパスを取得
	 * @access	private
	 * @static
	 * @param	DirectoryIterator
	 * @return	array
	 */
	private static function getFilePaths (DirectoryIterator $di)
	{
		$paths = array();
		foreach ($di as $dir) {
			if ($dir->isDot() || $dir->isLink()) {
				// 何もしない
			} else if ($dir->isFile()) {
				if (strtolower($dir->getExtension()=="php")) {
					$paths[] = $dir->getPathname();
				}
			} else if ($dir->isDir()) {
				$tmp = self::getFilePaths(new DirectoryIterator($dir->getPathname()));
				$paths = array_merge($paths, $tmp);
			}

		}
		return $paths;
	}

	/**
	 * 指定ファイルの内容を取得
	 * @static
	 * @access	private
	 * @param	string	$path
	 * @return	string
	 */
	private static function getFileContents ($path)
	{
		if (self::$debug) {
			return file_get_contents($path);
		} else {
			return php_strip_whitespace($path);
		}
	}

	/**
	 * Pharを生成
	 * @access	private
	 * @static
	 * @return	Phar
	 */
	private static function create ()
	{
		if (file_exists(self::$phar_path)) {
			if (is_writable(self::$phar_path)) {
				@unlink(self::$phar_path);
			} else {
				$msg = sprintf("%s exists, but can't be deleted");
				throw new RuntimeException($msg, 1);
			}
		}
		$phar = new Phar(self::$phar_path, 0, basename(self::$phar_path));

		// エントリーポイント
		$entry_point = sprintf("%s/starter.php", self::$src_dir);
		$phar->setDefaultStub(basename($entry_point));

		// その他ファイル
		$rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator(self::$src_dir));
		foreach ($rii as $node) {
			$path = str_replace(self::$src_dir, "", $node->getPathname());
			if (preg_match("/^.*\.tmp$/", $path)) { // *.tmpは含めない
				continue;
			}
			$phar->addFromString($path, self::getFileContents($node->getPathname()));
		}

		return $phar;
	}

	/**
	 * 実行
	 * @access	public
	 * @static
	 * @return	void
	 */
	public static function run ()
	{
		self::$src_dir = realpath(sprintf("%s/../src", __DIR__));
		self::$debug = (isset($_SERVER["argv"][1]) && $_SERVER["argv"][1]=="release") ? false : true;
		self::$phar_path = sprintf("%s/%s/Adelie.phar", __DIR__, (self::$debug ? "debug" : "release"));

		$phar = self::create();
		self::finish($phar);
	}
}

try {
	Build::run();
} catch (Exception $e) {
	Build::error($e);
}



