<?php
/**
 * String Class
 * @package	Adelie
 */
namespace Adelie;

final class String
{
	const RAND_STR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

	/**
	 * constructor
	 * @access	private
	 */
	private function __construct ()
	{
	}

	/**
	 * convert underscore formed string to camel formed one
	 * @access	public
	 * @static
	 * @param	string	$str
	 * @return	string
	 */
	public static function toCamel ($str="")
	{
		$tmp = \explode("_", \trim($str, "_"));
		$camel = "";
		foreach ($tmp as $key=>$val) {
			$camel .= $key ? \ucwords($val) : \strtolower($val);
		}
		return $camel;
	}

	/**
	 * convert underscore formed string to pascal formed one
	 * @access	public
	 * @static
	 * @param	string	$str
	 * @return	string
	 */
	public static function toPascal ($str="")
	{
		$str = \str_replace("_", " ", $str);
		$str = \ucwords(\strtolower($str));
		return \str_replace(" ", "", $str);
	}

	/**
	 * convert camel or pascal formed string to underscore formed one
	 * @access	public
	 * @static
	 * @param	string	$str
	 * @return	string
	 */
	public static function toUnderScore ($str="")
	{
		$str = \trim(\preg_replace("/([A-Z])/", " \$1", $str));
		$str = \strtolower($str);
		return \str_replace(" ", "_", $str);
	}

	/**
	 * create string at random
	 * @access	public
	 * @static
	 * @param	integer	$num	string length
	 * @return	string
	 */
	public static function createToken ($len=16)
	{
		$len = \intval($len);
		$str = "";
		$strlen = \strlen(self::RAND_STR) - 1;
		for ($i=0; $i<$len; $i++) {
			$idx = \mt_rand(0, $strlen);
			$str .= \substr(self::RAND_STR, $idx, 1);
		}
		return $str;
	}
}
