<?php
/**
 * PostgreSQL Information Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

require_once \sprintf("phar://%s/core/db/AbstractDbInfo.php", namespace\PHAR);
require_once \sprintf("phar://%s/core/db/DbPgsql.php", namespace\PHAR);

final class DbPgsqlInfo extends namespace\AbstractDbInfo
{
	/**
	 * constructor
	 * @access	public
	 * @param	\Adelie\AbstractDb	$dsn
	 */
	public function __construct (namespace\AbstractDb $db)
	{
		parent::__construct($db);

		// get table name
		$sql  = "SELECT table_name, column_name, data_type FROM information_schema.columns ";
		$sql .= "WHERE table_schema = 'public' ORDER BY table_name, ordinal_position ";
		$db->prepare($sql);
		$db->exec();
		while ($db->fetch()) {
			$table = $db->get("table_name");
			$column = $db->get("column_name");
			$this->columns[$table][$column] = array(
				"php_type" => $this->getPhpType($db->get("data_type")),
				"pdo_type" => $this->getPdoType($db->get("data_type"))
			);
		}
		$db->free();
	}

	/**
	 * get PDO data type corresponding to the passed $type
	 * @access	protected
	 * @param	string	$type
	 * @return	integer
	 */
	protected function getPdoType ($type)
	{
		$type = \strtolower($type);
		switch ($type) {
			case "smallint":
			case "integer":
				$cast = "\\PDO::PARAM_INT";
				break;
			case "bigint":
				$cast = (\PHP_INT_SIZE==8) ? "\\PDO::PARAM_INT" : "\\PDO::PARAM_STR";
				break;
			case "bytea":
				$cast = "\\PDO::PARAM_LOB";
				break;
			default:
				$cast = "\\PDO::PARAM_STR";
				break;
		}
		return $cast;
	}

	/**
	 * get PHP data type corresponding to the passed $type
	 * @access	protected
	 * @param	string	$type
	 * @return	string
	 */
	protected function getPhpType ($type)
	{
		$type = \strtolower($type);
		switch ($type) {
			case "integer":
				$cast = "intval";
				break;
			case "real":
				$cast = "floatval";
				break;
			case "blob":
			case "null":
				$cast = "";
				break;
			default:
				$cast = "strval";
				break;
		}
		return $cast;
	}
}
