<?php
/**
 * DB Factory Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class DbFactory
{
	/**
	 * constructor
	 * @access	private
	 */
	private function __construct ()
	{
	}

	/**
	 * create DB object
	 * @access	public
	 * @static
	 * @param	\Adelie\Dsn	$dsn	DSN Object
	 * @return	\Adelie\AbstractDb
	 */
	public static function create (namespace\Dsn $dsn)
	{
		$obj = $dsn->createDbObjName(true);
		$path = $dsn->createDbObjPath();
		require_once $path;
		if (\is_callable(array($obj, "getInstance"))) {
			return \call_user_func(array($obj, "getInstance"), $dsn);
		} else {
			throw new \UnexpectedValueException("Invalid DB driver specified.");
		}
	}
}
