<?php
/**
 * View Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class View
{
	private static $instance;
	private static $params;
	private static $site_id;

	private $request;
	private $tpl;

	/**
	 * Constructor
	 * @access	protected
	 * $param	\Adelie\Request	$request
	 */
	protected function __construct (namespace\Request $request)
	{
		self::$site_id = $request->getSiteId();
		$this->request = $request;
		$this->tpl = "";
	}

	/**
	 * create instance
	 * @access	public
	 * @static
	 * @param	\Adelie\Request	$request
	 * @return	\Adelie\View
	 */
	public static function getInstance (namespace\Request $request)
	{
		if (self::$instance==null) {
			self::$instance = new self($request);
		}
		return self::$instance;
	}

	/**
	 * load another template file in a template
	 * @access	public
	 * @static
	 * @param	string	$tpl
	 * @return	void
	 * @todo	ViewExceptionの置き換え
	 */
	public static function load ($tpl)
	{
		$site_id = self::$site_id ? \sprintf("/%s", self::$site_id) : "";
		$site_id = namespace\DIR_TPL . $site_id;
		$path = \sprintf("%s/%s.%s", $site_id, $tpl, namespace\TPL_EXT);
		if (!\is_readable($path)) {
			$msg = namespace\Error::get(namespace\Error::E_TPL);
			throw new namespace\ViewException($msg, namespace\Error::E_TPL);
		}
		if (is_array(self::$params)) {
			\extract(self::$params);
		}
		require_once $path;
	}

	/**
	 * set a templace
	 * @access	public
	 * @param	string	$tpl
	 * @return	void
	 */
	public function setTemplate ($tpl)
	{
		$this->tpl = \sprintf("%s.%s", $tpl, namespace\TPL_EXT);
	}

	/**
	 * assign a parameter
	 * @access	public
	 * @param	string	$key
	 * @param	mixed	$value
	 * @return	void
	 */
	public function assign ($key, $value)
	{
		self::$params[$key] = $value;
	}

	/**
	 * render
	 * @access	public
	 * @return	void
	 */
	public function render ()
	{
		$site_id = self::$site_id ? \sprintf("/%s", self::$site_id) : "";
		$site_id = DIR_TPL . $site_id;
		$path = \sprintf("%s/%s", $site_id, $this->tpl);
		if (!\is_readable($path)) {
			$msg = namespace\Error::get(namespace\Error::E_TPL, $path);
			throw new namespace\AdelieException($msg, namespace\Error::E_TPL);
		}
		if (\is_array(self::$params)) {
			\extract(self::$params);
		}
		require_once $path;
	}
}
