<?php
/**
 * Abstract Controller Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

require_once \sprintf("phar://%s/core/Response.php", namespace\PHAR);

abstract class AbstractController
{
	protected $request;
	protected $response;
	protected $exception;

	/**
	 * constructor
	 * @access	protected
	 * @param	\Adelie\Request		$request
	 * @param	\Exception	$exception
	 */
	protected function __construct (namespace\Request $request, \Exception $exception=null)
	{
		$this->request = $request;
		$this->response = namespace\Response::getInstance($this->request);
		$this->exception = $exception;
	}

	/**
	 * do default action
	 * @access	public
	 * @return	void
	 */
	public function doDefaultAction ()
	{
		$this->response->setStatus();
	}

	/**
	 * get the response
	 * @access	public
	 * @return	\Adelie\Response
	 */
	public function getResponse ()
	{
		return $this->response;
	}
}