<?php
/**
 * show CLI help.
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class HelpCli extends namespace\AbstractCli
{
	public function __contruct ()
	{
		parent::__construct();
		$this->setLockMode(false);
	}

	/**
	 *
	 * @access	private
	 * @param	string	$path
	 * @return	string
	 */
	private function parse ($path)
	{
		$tmp = \token_get_all(\file_get_contents($path, false, null, -1, 2048));
		$doc = "";
		foreach ($tmp as $val) {
			if ($val[0]!=\T_DOC_COMMENT) { continue; }
			$doc = \trim($val[1]);
			if (\strpos($doc, "@package")!==false) {
				break;
			} else {
				$doc = "";
			}
		}
		unset($tmp);
		if (!\strlen($doc)) {
			return "";
		}

		$doc = \trim($doc, "/* \t\r\n");
		$lines = \explode("\n", $doc);
		return \trim(@$lines[0], "/* \t\r\n");;
	}

	/**
	 * execute
	 * @access	public
	 * @return	void
	 */
	public function run ()
	{
		$paths = \glob(namespace\DIR_CLI."/?*Cli.php");
		$lines = array();
		$max = 0;
		foreach ($paths as $path) {
			$obj = \preg_replace("/(.+)Cli\.php/u", "\\1", \basename($path));
			$cmd = namespace\String::toUnderScore($obj);
			$len = \strlen($cmd);
			$max = ($max>$len) ? $max : $len;
			if ($len) {
				$lines[] = array($cmd, $this->parse($path));
			}
		}

		echo "\n";
		echo "Usage: php ".namespace\PHAR." <sub_command> [args...]\n";
		echo "\n";
		echo " ".namespace\NAME." Sub Commands ---\n";
		echo "\n";
		echo "  @check      Check whether Adelie framework can run.\n";
		echo "  @setup      Setup Adelie framework.\n";
		echo "  @skelton    Create a file from skelton.\n";
		echo "  @dao        Create data access objects.\n";
		echo "  @help       This help.\n";
		echo "\n";
		echo " User Defined Sub Commands ---\n";
		echo "\n";
		foreach ($lines as $val) {
			\printf("  %-{$max}s  %s\n", $val[0], $val[1]);
		}
		echo "\n";
	}
}
