<?php
/**
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class CheckCli extends AbstractCli
{
	private $fatal;
	private $warn;
	private $modules;

	/**
	 * Constructor
	 * @access	public
	 */
	public function __contruct ()
	{
		parent::__construct();
		$this->fatal = false;
		$this->warn = false;
		$this->modules = \get_loaded_extensions();
	}

	/**
	 * check PHP version number
	 * @access	private
	 * @return	void
	 */
	private function version ()
	{
		echo "PHP Version       : ";
		if (\version_compare(\PHP_VERSION, "5.3.0")>=0) {
			\printf("<OK>   PHP version is %s.\n", \PHP_VERSION);
		} else {
			\printf("<NG>   PHP version is %s.\n", \PHP_VERSION);
			$this->fatal = true;
		}
	}

	/**
	 * Check the integer size.
	 * @access	private
	 * @return	void
	 */
	private function integer ()
	{
		echo "Integer Size      : ";
		if (\PHP_INT_SIZE==8) {
			\printf("<OK>   You can use %dbyte integer. The max is %d.\n", \PHP_INT_SIZE, \PHP_INT_MAX);
		} else {
			\printf("<WARN> You can use %dbyte integer not 8byte one. The max is %d.\n", \PHP_INT_SIZE, \PHP_INT_MAX);
			$this->warn = true;
		}
	}

	/**
	 * Check internal encoding;
	 * @access	private
	 * @return	void
	 */
	private function encoding ()
	{
		echo "Internal Encoding : ";
	}

	/**
	 * Compress DAO files
	 * @access	private
	 * @return	void
	 */
	private function compress ()
	{
		echo "DAO Compress      : ";
	}

	/**
	 * execute
	 * @access	public
	 * @return	void
	 */
	public function run ()
	{
		echo "\n";
		$this->version();
		$this->integer();
		//$this->encoding();
		$this->compress();
v($this->modules);
		echo "\n";
		if ($this->fatal) {
			echo "Adelie **CANNOT** run.";
		} else if ($this->warn) {
			echo "Adelie can run **CONDITIONALLY**.\n";
			echo "See warnings.\n";
		} else {
			echo "Adelie can **RUN**.\n";
		}
		echo "\n";
	}
}
