/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.tape;

import java.io.IOException;
import java.io.Reader;
import net.morilib.util.IntRingBuffer;
import net.morilib.util.tape.CharTape;
import net.morilib.util.tape.TapeException;

public class ReaderCharTape
implements CharTape {
    private Reader reader;
    private IntRingBuffer buffer;

    public ReaderCharTape(Reader reader, int size) {
        this.reader = reader;
        this.buffer = new IntRingBuffer(size + 1);
        this.buffer.put(-1);
    }

    @Override
    public int readc() {
        return this.buffer.isEmpty() ? 0 : this.buffer.get(1);
    }

    @Override
    public boolean writec(int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean moveLeft() {
        if (this.buffer.isEmpty()) {
            return false;
        }
        this.buffer.remove();
        return true;
    }

    @Override
    public boolean moveRight() {
        try {
            if (this.buffer.peek() == -1) {
                int res = this.reader.read();
                this.buffer.add(res);
                this.buffer.put(-1);
            } else {
                int res = this.buffer.peek();
                this.buffer.add(res);
            }
            return true;
        }
        catch (IOException e) {
            throw new TapeException(e);
        }
    }

    @Override
    public Integer read() {
        return this.readc();
    }

    @Override
    public boolean write(Integer symbol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int mark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int back() {
        throw new UnsupportedOperationException();
    }
}

