/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.string;

import net.morilib.lang.transform.CharacterIndicator;
import net.morilib.lang.transform.Ctype;
import net.morilib.lang.transform.Transform;
import net.morilib.util.string.InvalidStringException;

public final class StringTransforms {
    public static final Transform<String> HYPHEN_TO_CAMEL = new Transform<String>(){

        @Override
        public String f(String s) {
            CharacterIndicator ind = Ctype.JAVA_IDENTIFIER_START;
            StringBuilder b = new StringBuilder();
            boolean hyphen = false;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (hyphen) {
                    if (Character.isLowerCase(c)) {
                        b.append(Character.toUpperCase(c));
                    } else if (ind.ki(c)) {
                        b.append(c);
                    } else {
                        throw new InvalidStringException();
                    }
                    hyphen = false;
                } else if (c == '-') {
                    hyphen = true;
                } else if (ind.ki(c)) {
                    b.append(c);
                } else {
                    throw new InvalidStringException();
                }
                ind = Ctype.JAVA_IDENTIFIER_PART;
                ++i;
            }
            return b.toString();
        }
    };
    public static final Transform<String> CAMEL_TO_HYPHEN = new Transform<String>(){

        @Override
        public String f(String s) {
            CharacterIndicator ind = Ctype.JAVA_IDENTIFIER_START;
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c > '\u0000' && Character.isUpperCase(c)) {
                    b.append('-').append(c);
                } else if (ind.ki(c)) {
                    b.append(c);
                } else {
                    throw new InvalidStringException();
                }
                ind = Ctype.JAVA_IDENTIFIER_PART;
                ++i;
            }
            return b.toString();
        }
    };
    public static final Transform<String> CAPITALIZE_FIRST = new Transform<String>(){

        @Override
        public String f(String s) {
            StringBuilder b = new StringBuilder();
            if (s.length() != 0) {
                if (Character.isLowerCase(s.charAt(0))) {
                    b.append(Character.toUpperCase(s.charAt(0)));
                    b.append(s, 1, s.length());
                } else {
                    return s;
                }
            }
            return b.toString();
        }
    };

    private StringTransforms() {
    }
}

