/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.morilib.util.Objects;
import net.morilib.util.set.CachedSet;

public abstract class Flat3CachedSet<E>
extends CachedSet<E> {
    private E ch1 = null;
    private E ch2 = null;
    private E ch3 = null;
    private int sizeModCount = 0;

    @Override
    protected Iterator<E> cacheIterator() {
        return new Iterator<E>(){
            private int ptrExModCount;
            private boolean removed;
            {
                this.ptrExModCount = Flat3CachedSet.this.sizeModCount & 0xFFFF0000;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return (this.ptrExModCount & 0xFFFF) < Flat3CachedSet.this.cacheSize();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removed = false;
                switch (this.ptrExModCount++ & 0xFFFF) {
                    case 0: {
                        return Flat3CachedSet.this.ch1;
                    }
                    case 1: {
                        return Flat3CachedSet.this.ch2;
                    }
                    case 2: {
                        return Flat3CachedSet.this.ch3;
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            public void remove() {
                int p = this.ptrExModCount;
                int s = Flat3CachedSet.this.sizeModCount;
                if (this.removed) {
                    throw new IllegalStateException();
                }
                if ((p & 0xFFFF0000) != (s & 0xFFFF0000)) {
                    throw new ConcurrentModificationException();
                }
                Flat3CachedSet.this.removeCache((p & 0xFFFF) - 1);
                this.ptrExModCount &= 0xFFFF;
                this.ptrExModCount |= Flat3CachedSet.this.sizeModCount & 0xFFFF0000;
                --this.ptrExModCount;
                this.removed = true;
            }
        };
    }

    @Override
    protected int cacheSize() {
        return this.sizeModCount & 0xFFFF;
    }

    @Override
    protected boolean isCacheFull() {
        return (this.sizeModCount & 0xFFFF) == 3;
    }

    @Override
    protected int hitCache(Object e) {
        int z = this.sizeModCount & 0xFFFF;
        switch (z) {
            case 0: {
                return -1;
            }
            case 1: {
                return Objects.equals(e, this.ch1) ? 0 : -1;
            }
            case 2: {
                return Objects.equals(e, this.ch1) ? 0 : (Objects.equals(e, this.ch2) ? 1 : -1);
            }
        }
        return Objects.equals(e, this.ch1) ? 0 : (Objects.equals(e, this.ch2) ? 1 : (Objects.equals(e, this.ch3) ? 2 : -1));
    }

    @Override
    protected E getCache(int i) {
        switch (i) {
            case 0: {
                return this.ch1;
            }
            case 1: {
                return this.ch2;
            }
            case 2: {
                return this.ch3;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void addCache(E e) {
        int z = this.sizeModCount & 0xFFFF;
        switch (z) {
            case 0: {
                this.ch1 = e;
                break;
            }
            case 1: {
                this.ch2 = e;
                break;
            }
            case 2: {
                this.ch3 = e;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.sizeModCount += 65537;
    }

    @Override
    protected void removeCache(int i) {
        if (i >= (this.sizeModCount & 0xFFFF)) {
            throw new IllegalArgumentException();
        }
        switch (i) {
            case 0: {
                this.ch1 = this.ch2;
            }
            case 1: {
                this.ch2 = this.ch3;
            }
            case 2: {
                this.ch3 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.sizeModCount += 65535;
    }

    @Override
    protected void setCache(int i, E e) {
        if (i >= (this.sizeModCount & 0xFFFF)) {
            throw new IllegalArgumentException();
        }
        switch (i) {
            case 0: {
                this.ch1 = e;
                break;
            }
            case 1: {
                this.ch2 = e;
                break;
            }
            case 2: {
                this.ch3 = e;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.sizeModCount += 65536;
    }

    @Override
    protected void clearCache() {
        this.ch3 = null;
        this.ch2 = null;
        this.ch1 = null;
        this.sizeModCount &= 0xFFFF0000;
        this.sizeModCount += 65536;
    }
}

