/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractIntegerCollection;
import net.morilib.util.primitive.AbstractLongSet;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.IntegerValueMap;
import net.morilib.util.primitive.map.po.LongMap;
import net.morilib.util.primitive.map.pp.LongIntegerMap;

public abstract class AbstractLongIntegerMap
implements LongIntegerMap {
    private transient LongSet keySet = null;
    private transient IntegerCollection values = null;
    private transient Set<LongMap.PrimitiveEntryK<Integer>> entrySetK = null;
    private transient Set<IntegerValueMap.PrimitiveEntryV<Long>> entrySetV = null;
    private transient Set<Map.Entry<Long, Integer>> entrySet = null;

    @Override
    public void clear() {
        Iterator<LongIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(int v) {
        for (LongIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public int f(long k) {
        for (LongIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Integer getElement(long k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet longKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(LongIntegerMap map) {
        for (LongIntegerMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKeyElement((Long)key);
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        if (key instanceof Integer) {
            return this.getElement((Long)key);
        }
        return null;
    }

    @Override
    public Integer put(Long key, int value) {
        return this.putElement((long)key, value);
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof Integer) {
            return this.removeElement((Long)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Integer> m) {
        for (Map.Entry<? extends Long, ? extends Integer> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongSet keySet() {
        return this.longKeySet();
    }

    @Override
    public Set<Map.Entry<Long, Integer>> entrySet() {
        final Set<LongIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Long, Integer>>(){

                @Override
                public Iterator<Map.Entry<Long, Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Long, Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Long, Integer> next() {
                            final LongIntegerMap.PrimitiveEntry o = (LongIntegerMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Long, Integer>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(long k) {
        for (LongIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer get(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Integer put(int k, Integer v) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((long)k, v);
    }

    @Override
    public Integer removeElement(long k) {
        Iterator<LongIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            LongIntegerMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            int r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Integer remove(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<LongMap.PrimitiveEntryK<Integer>> longKeyEntrySet() {
        final Set<LongIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<LongMap.PrimitiveEntryK<Integer>>(){

                @Override
                public Iterator<LongMap.PrimitiveEntryK<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongMap.PrimitiveEntryK<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongMap.PrimitiveEntryK<Integer> next() {
                            final LongIntegerMap.PrimitiveEntry o = (LongIntegerMap.PrimitiveEntry)i.next();
                            return new LongMap.PrimitiveEntryK<Integer>(){

                                @Override
                                public long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Integer putElement(long k, Integer v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongMap<Integer> map) {
        for (LongMap.PrimitiveEntryK<Integer> e : map.longKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<IntegerValueMap.PrimitiveEntryV<Long>> intValueEntrySet() {
        final Set<LongIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<IntegerValueMap.PrimitiveEntryV<Long>>(){

                @Override
                public Iterator<IntegerValueMap.PrimitiveEntryV<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerValueMap.PrimitiveEntryV<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerValueMap.PrimitiveEntryV<Long> next() {
                            final LongIntegerMap.PrimitiveEntry o = (LongIntegerMap.PrimitiveEntry)i.next();
                            return new IntegerValueMap.PrimitiveEntryV<Long>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public int getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public int setValue(int value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public int getElement(Object k) {
        if (k instanceof Long) {
            return this.f((Long)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int putElement(Long k, int v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerValueMap<Long> map) {
        for (IntegerValueMap.PrimitiveEntryV<Long> e : map.intValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection intValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            return this.containsValueElement((Integer)value);
        }
        return false;
    }

    @Override
    public Integer put(Long key, Integer value) {
        return this.putElement((long)key, (int)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (LongIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof LongIntegerMap)) break block1;
            m = (LongIntegerMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (LongIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractLongSet {
        private Set<LongIntegerMap.PrimitiveEntry> eset;

        private KSet(Set<LongIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<LongIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public long next() {
                    return ((LongIntegerMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongIntegerMap.this.size();
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractLongIntegerMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongIntegerMap.this.clear();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractIntegerCollection {
        private Set<LongIntegerMap.PrimitiveEntry> eset;

        private VCol(Set<LongIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<LongIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public int next() {
                    return ((LongIntegerMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongIntegerMap.this.size();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractLongIntegerMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongIntegerMap.this.clear();
        }
    }
}

