/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractFloatCollection;
import net.morilib.util.primitive.AbstractIntegerSet;
import net.morilib.util.primitive.FloatCollection;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.FloatValueMap;
import net.morilib.util.primitive.map.po.IntegerMap;
import net.morilib.util.primitive.map.pp.IntegerFloatMap;

public abstract class AbstractIntegerFloatMap
implements IntegerFloatMap {
    private transient IntegerSet keySet = null;
    private transient FloatCollection values = null;
    private transient Set<IntegerMap.PrimitiveEntryK<Float>> entrySetK = null;
    private transient Set<FloatValueMap.PrimitiveEntryV<Integer>> entrySetV = null;
    private transient Set<Map.Entry<Integer, Float>> entrySet = null;

    @Override
    public void clear() {
        Iterator<IntegerFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(float v) {
        for (IntegerFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public float f(int k) {
        for (IntegerFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Float getElement(int k) {
        return Float.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntegerSet intKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(IntegerFloatMap map) {
        for (IntegerFloatMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Float) {
            return this.containsKeyElement((Integer)key);
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        if (key instanceof Float) {
            return this.getElement((Integer)key);
        }
        return null;
    }

    @Override
    public Float put(Integer key, float value) {
        return this.putElement((int)key, value);
    }

    @Override
    public Float remove(Object key) {
        if (key instanceof Float) {
            return this.removeElement((Integer)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Float> m) {
        for (Map.Entry<? extends Integer, ? extends Float> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerSet keySet() {
        return this.intKeySet();
    }

    @Override
    public Set<Map.Entry<Integer, Float>> entrySet() {
        final Set<IntegerFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, Float>>(){

                @Override
                public Iterator<Map.Entry<Integer, Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Integer, Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Integer, Float> next() {
                            final IntegerFloatMap.PrimitiveEntry o = (IntegerFloatMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Integer, Float>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(int k) {
        for (IntegerFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float get(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return Float.valueOf(this.getElement(Float.valueOf(k)));
    }

    @Override
    public Float put(int k, Float v) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public Float removeElement(int k) {
        Iterator<IntegerFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            IntegerFloatMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            float r = e.getValue();
            i.remove();
            return Float.valueOf(r);
        }
        return null;
    }

    @Override
    public Float remove(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<IntegerMap.PrimitiveEntryK<Float>> intKeyEntrySet() {
        final Set<IntegerFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<IntegerMap.PrimitiveEntryK<Float>>(){

                @Override
                public Iterator<IntegerMap.PrimitiveEntryK<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerMap.PrimitiveEntryK<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerMap.PrimitiveEntryK<Float> next() {
                            final IntegerFloatMap.PrimitiveEntry o = (IntegerFloatMap.PrimitiveEntry)i.next();
                            return new IntegerMap.PrimitiveEntryK<Float>(){

                                @Override
                                public int getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Float putElement(int k, Float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerMap<Float> map) {
        for (IntegerMap.PrimitiveEntryK<Float> e : map.intKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<FloatValueMap.PrimitiveEntryV<Integer>> floatValueEntrySet() {
        final Set<IntegerFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<FloatValueMap.PrimitiveEntryV<Integer>>(){

                @Override
                public Iterator<FloatValueMap.PrimitiveEntryV<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatValueMap.PrimitiveEntryV<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatValueMap.PrimitiveEntryV<Integer> next() {
                            final IntegerFloatMap.PrimitiveEntry o = (IntegerFloatMap.PrimitiveEntry)i.next();
                            return new FloatValueMap.PrimitiveEntryV<Integer>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public float getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public float setValue(float value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public float getElement(Object k) {
        if (k instanceof Integer) {
            return this.f((Integer)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public float putElement(Integer k, float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatValueMap<Integer> map) {
        for (FloatValueMap.PrimitiveEntryV<Integer> e : map.floatValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection floatValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Float) {
            return this.containsValueElement(((Float)value).floatValue());
        }
        return false;
    }

    @Override
    public Float put(Integer key, Float value) {
        return this.putElement((int)key, value.floatValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (IntegerFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof IntegerFloatMap)) break block1;
            m = (IntegerFloatMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).floatValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (IntegerFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractIntegerSet {
        private Set<IntegerFloatMap.PrimitiveEntry> eset;

        private KSet(Set<IntegerFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<IntegerFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public int next() {
                    return ((IntegerFloatMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerFloatMap.this.size();
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractIntegerFloatMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerFloatMap.this.clear();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractFloatCollection {
        private Set<IntegerFloatMap.PrimitiveEntry> eset;

        private VCol(Set<IntegerFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<IntegerFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public float next() {
                    return ((IntegerFloatMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerFloatMap.this.size();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractIntegerFloatMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerFloatMap.this.clear();
        }
    }
}

