/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractFloatSet;
import net.morilib.util.primitive.AbstractLongCollection;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.LongCollection;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.LongValueMap;
import net.morilib.util.primitive.map.po.FloatMap;
import net.morilib.util.primitive.map.pp.FloatLongMap;

public abstract class AbstractFloatLongMap
implements FloatLongMap {
    private transient FloatSet keySet = null;
    private transient LongCollection values = null;
    private transient Set<FloatMap.PrimitiveEntryK<Long>> entrySetK = null;
    private transient Set<LongValueMap.PrimitiveEntryV<Float>> entrySetV = null;
    private transient Set<Map.Entry<Float, Long>> entrySet = null;

    @Override
    public void clear() {
        Iterator<FloatLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(long v) {
        for (FloatLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public long f(float k) {
        for (FloatLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Long getElement(float k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet floatKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(FloatLongMap map) {
        for (FloatLongMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return this.containsKeyElement(((Float)key).floatValue());
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        if (key instanceof Long) {
            return this.getElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public Long put(Float key, long value) {
        return this.putElement(key.floatValue(), value);
    }

    @Override
    public Long remove(Object key) {
        if (key instanceof Long) {
            return this.removeElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Long> m) {
        for (Map.Entry<? extends Float, ? extends Long> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatSet keySet() {
        return this.floatKeySet();
    }

    @Override
    public Set<Map.Entry<Float, Long>> entrySet() {
        final Set<FloatLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Float, Long>>(){

                @Override
                public Iterator<Map.Entry<Float, Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Float, Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Float, Long> next() {
                            final FloatLongMap.PrimitiveEntry o = (FloatLongMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Float, Long>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(float k) {
        for (FloatLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Long get(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Long put(int k, Long v) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((float)k, v);
    }

    @Override
    public Long removeElement(float k) {
        Iterator<FloatLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            FloatLongMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            long r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Long remove(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<FloatMap.PrimitiveEntryK<Long>> floatKeyEntrySet() {
        final Set<FloatLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<FloatMap.PrimitiveEntryK<Long>>(){

                @Override
                public Iterator<FloatMap.PrimitiveEntryK<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatMap.PrimitiveEntryK<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatMap.PrimitiveEntryK<Long> next() {
                            final FloatLongMap.PrimitiveEntry o = (FloatLongMap.PrimitiveEntry)i.next();
                            return new FloatMap.PrimitiveEntryK<Long>(){

                                @Override
                                public float getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Long putElement(float k, Long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatMap<Long> map) {
        for (FloatMap.PrimitiveEntryK<Long> e : map.floatKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<LongValueMap.PrimitiveEntryV<Float>> longValueEntrySet() {
        final Set<FloatLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<LongValueMap.PrimitiveEntryV<Float>>(){

                @Override
                public Iterator<LongValueMap.PrimitiveEntryV<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongValueMap.PrimitiveEntryV<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongValueMap.PrimitiveEntryV<Float> next() {
                            final FloatLongMap.PrimitiveEntry o = (FloatLongMap.PrimitiveEntry)i.next();
                            return new LongValueMap.PrimitiveEntryV<Float>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public long setValue(long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public long getElement(Object k) {
        if (k instanceof Float) {
            return this.f(((Float)k).floatValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long putElement(Float k, long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongValueMap<Float> map) {
        for (LongValueMap.PrimitiveEntryV<Float> e : map.longValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection longValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Long) {
            return this.containsValueElement((Long)value);
        }
        return false;
    }

    @Override
    public Long put(Float key, Long value) {
        return this.putElement(key.floatValue(), (long)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatLongMap)) break block1;
            m = (FloatLongMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractFloatSet {
        private Set<FloatLongMap.PrimitiveEntry> eset;

        private KSet(Set<FloatLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<FloatLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public float next() {
                    return ((FloatLongMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatLongMap.this.size();
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractFloatLongMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatLongMap.this.clear();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractLongCollection {
        private Set<FloatLongMap.PrimitiveEntry> eset;

        private VCol(Set<FloatLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<FloatLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public long next() {
                    return ((FloatLongMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatLongMap.this.size();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractFloatLongMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatLongMap.this.clear();
        }
    }
}

