/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.op;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.map.op.ByteValueMap;

public abstract class AbstractByteValueMap<K>
implements ByteValueMap<K> {
    private transient Set<K> keySet = null;
    private transient ByteCollection values = null;

    @Override
    public void clear() {
        Iterator i = this.byteValueEntrySet().iterator();
        while (i.hasNext()) {
            i.remove();
        }
    }

    @Override
    public boolean containsKey(Object k) {
        if (k instanceof Byte) {
            this.containsValueElement((Byte)k);
        }
        return false;
    }

    @Override
    public boolean containsValueElement(byte v) {
        for (ByteValueMap.PrimitiveEntryV e : this.byteValueEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public Byte get(Object k) {
        if (k instanceof Byte) {
            for (ByteValueMap.PrimitiveEntryV e : this.byteValueEntrySet()) {
                Object l = e.getKey();
                if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
                return e.getValue();
            }
        }
        return null;
    }

    @Override
    public byte getElement(Object k) {
        if (k instanceof Byte) {
            for (ByteValueMap.PrimitiveEntryV e : this.byteValueEntrySet()) {
                Object l = e.getKey();
                if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
                return e.getValue();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.byteValueEntrySet())) : this.keySet;
    }

    @Override
    public Byte put(K k, byte v) {
        boolean b = this.containsKey(k);
        byte r = this.putElement(k, v);
        return b ? Byte.valueOf(r) : null;
    }

    @Override
    public void putAllElement(ByteValueMap<K> map) {
        for (ByteValueMap.PrimitiveEntryV<K> e : map.byteValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection byteValues() {
        return this.values == null ? (this.values = new VCol(this.byteValueEntrySet())) : this.values;
    }

    @Override
    public boolean containsValue(int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((byte)v);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Byte) {
            return this.containsValueElement((Byte)value);
        }
        return false;
    }

    @Override
    public Byte put(K key, Byte value) {
        if (value instanceof Byte) {
            return this.putElement(key, value);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Byte> m) {
        for (ByteValueMap.PrimitiveEntryV e : this.byteValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<Byte> values() {
        final Iterator i = this.byteValueEntrySet().iterator();
        return new AbstractCollection<Byte>(){

            @Override
            public Iterator<Byte> iterator() {
                return new Iterator<Byte>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Byte next() {
                        return ((ByteValueMap.PrimitiveEntryV)i.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractByteValueMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, Byte>> entrySet() {
        final Iterator i = this.byteValueEntrySet().iterator();
        return new AbstractSet<Map.Entry<K, Byte>>(){

            @Override
            public Iterator<Map.Entry<K, Byte>> iterator() {
                return new Iterator<Map.Entry<K, Byte>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Byte> next() {
                        final ByteValueMap.PrimitiveEntryV e = (ByteValueMap.PrimitiveEntryV)i.next();
                        return new Map.Entry<K, Byte>(){

                            @Override
                            public K getKey() {
                                return e.getKey();
                            }

                            @Override
                            public Byte getValue() {
                                return e.getValue();
                            }

                            @Override
                            public Byte setValue(Byte value) {
                                return e.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractByteValueMap.this.size();
            }
        };
    }

    @Override
    public Byte remove(Object k) {
        Iterator i = this.byteValueEntrySet().iterator();
        while (i.hasNext()) {
            ByteValueMap.PrimitiveEntryV e = i.next();
            Object l = e.getKey();
            if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
            byte r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteValueMap.PrimitiveEntryV e : this.byteValueEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteValueMap)) break block1;
            m = (ByteValueMap)obj;
            i = this.byteValueEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                if (m.containsKey(o.getKey()) && m.getElement(o.getKey()) == o.getValue()) continue;
                return false;
lbl9:
                // 2 sources

                ** while (i.hasNext())
            }
lbl10:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteValueMap.PrimitiveEntryV e : this.byteValueEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractSet<K> {
        private Set<ByteValueMap.PrimitiveEntryV<K>> eset;

        private KSet(Set<ByteValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public K next() {
                    return ((ByteValueMap.PrimitiveEntryV)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteValueMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractByteValueMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteValueMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteValueMap.this.clear();
        }
    }

    private class VCol
    extends AbstractByteCollection {
        private Set<ByteValueMap.PrimitiveEntryV<K>> eset;

        private VCol(Set<ByteValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator ei = this.eset.iterator();
            return new ByteIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public byte next() {
                    return ((ByteValueMap.PrimitiveEntryV)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteValueMap.this.size();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }
    }
}

