/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractLongSet;
import net.morilib.util.primitive.LongCollection;
import net.morilib.util.primitive.iterator.LongIterator;

public class LongHashSet
extends AbstractLongSet
implements Serializable {
    private static final long serialVersionUID = 4823620077843167065L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;

    /*
     * Unable to fully structure code
     */
    public LongHashSet(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl12
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl12:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public LongHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongHashSet(float loadFactor) {
        this(16, loadFactor);
    }

    public LongHashSet() {
        this(16, 0.75f);
    }

    public LongHashSet(LongCollection col) {
        this(16, 0.75f);
        this.addAllLong(col);
    }

    @Override
    public LongIterator longIterator() {
        return new LongIterator(){
            private int ptr = -1;
            private Ent e = this._next();
            private Ent remove = null;
            private int exModCount;
            {
                this.exModCount = LongHashSet.this.modCount;
            }

            /*
             * Unable to fully structure code
             */
            private Ent _next() {
                v0 = this.e = this.ptr < 0 ? null : Ent.access$0(this.e);
                if (this.e == null) ** GOTO lbl6
                return this.e;
lbl-1000:
                // 1 sources

                {
                    if (LongHashSet.access$1(LongHashSet.this)[this.ptr] == null) continue;
                    return LongHashSet.access$1(LongHashSet.this)[this.ptr];
lbl6:
                    // 2 sources

                    ** while (++this.ptr < LongHashSet.access$1((LongHashSet)LongHashSet.this).length)
                }
lbl7:
                // 1 sources

                return null;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public long next() {
                this.remove = this.e;
                if (this.e == null) {
                    throw new NoSuchElementException();
                }
                if (this.exModCount != LongHashSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.e = this._next();
                return this.remove.value;
            }

            @Override
            public void remove() {
                if (this.remove == null) {
                    throw new IllegalStateException();
                }
                LongHashSet.this.removeLong(this.remove.value);
                this.exModCount = LongHashSet.this.modCount;
                this.remove = null;
            }
        };
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(long k) {
        return (int)k;
    }

    private Ent _get(long k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsLong(long k) {
        return this._get(k) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            LongIterator bi = this.longIterator();
            while (bi.hasNext()) {
                long b = bi.next();
                int h = this.getHash(b) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(b);
                    continue;
                }
                ne[h].putEntry(b);
            }
        }
    }

    @Override
    public boolean addLong(long v) {
        int h = this.getHash(v) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(v);
            return false;
        }
        boolean r = this.ent[h].putEntry(v);
        if (!r) {
            ++this.size;
            this.resize();
        }
        return r;
    }

    private boolean _putEntry(long v) {
        int h = this.getHash(v) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(v);
            return true;
        }
        return this.ent[h].putEntry(v);
    }

    @Override
    public boolean addAllLong(LongCollection c) {
        int nd = c.size();
        boolean r = false;
        ++this.modCount;
        if (nd == 0) {
            return false;
        }
        this.size += nd;
        this.resize();
        LongIterator i = c.longIterator();
        while (i.hasNext()) {
            r = this._putEntry(i.next()) | r;
        }
        return r;
    }

    private Ent _remove(long k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == this.ent[h].value) {
            Ent r = this.ent[h];
            --this.size;
            this.ent[h] = r.next;
            return r;
        }
        --this.size;
        return this.ent[h].removeEntry(k);
    }

    @Override
    public boolean removeLong(long k) {
        return this._remove(k) != null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        LongIterator i = this.longIterator();
        while (i.hasNext()) {
            s.writeLong(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            this._putEntry(s.readLong());
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$1(LongHashSet longHashSet) {
        return longHashSet.ent;
    }

    private static class Ent {
        private long value;
        private Ent next;

        private Ent(long value) {
            this.value = value;
        }

        public int hashCode() {
            return (int)this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.value == e.value;
            }
            return false;
        }

        public String toString() {
            return Long.toString(this.value);
        }

        private Ent searchEntry(long k) {
            Ent f = this;
            while (f != null) {
                if (k == f.value) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent removeEntry(long k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.value) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private boolean putEntry(long k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.value) {
                    return true;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent(k);
            return false;
        }
    }
}

