/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractFloatVector;
import net.morilib.util.primitive.FloatCollection;

public class FloatArrayVector
extends AbstractFloatVector
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 3332872309405682099L;
    private float[] array;
    private transient int size;

    public FloatArrayVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new float[initialCapacity];
    }

    public FloatArrayVector() {
        this(10);
    }

    public FloatArrayVector(float[] bytes) {
        this.array = new float[bytes.length];
        this.size = this.array.length;
        System.arraycopy(bytes, 0, this.array, 0, bytes.length);
    }

    public FloatArrayVector(FloatCollection a) {
        this.array = a.toFloatArray();
        this.size = this.array.length;
    }

    public FloatArrayVector(FloatCollection ... as) {
        this.size = 0;
        FloatCollection[] floatCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            FloatCollection a = floatCollectionArray[n2];
            this.size += a.size();
            ++n2;
        }
        int s2 = 0;
        this.array = new float[this.size];
        FloatCollection[] floatCollectionArray2 = as;
        int n3 = as.length;
        n = 0;
        while (n < n3) {
            FloatCollection a = floatCollectionArray2[n];
            float[] b = a.toFloatArray();
            System.arraycopy(b, 0, this.array, s2, b.length);
            s2 += a.size();
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public FloatArrayVector(Collection<? extends FloatCollection> as) {
        this.size = 0;
        for (FloatCollection floatCollection : as) {
            this.size += floatCollection.size();
        }
        boolean bl = false;
        this.array = new float[this.size];
        for (FloatCollection floatCollection : as) {
            void var2_7;
            float[] b = floatCollection.toFloatArray();
            System.arraycopy(b, 0, this.array, (int)var2_7, b.length);
            var2_7 += floatCollection.size();
        }
    }

    public void ensureCapacity(int nsize) {
        if (nsize > this.array.length) {
            int ns = nsize;
            while (ns < this.array.length) {
                int n = ns = this.array.length < 0x4CCCCCCA ? this.array.length / 3 * 5 + 1 : Integer.MAX_VALUE;
            }
            float[] b = new float[ns];
            System.arraycopy(this.array, 0, b, 0, this.size);
            this.array = b;
        }
    }

    @Override
    public void addFloat(int index, float v) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        ++this.modCount;
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = v;
        ++this.size;
    }

    @Override
    public boolean addAllFloat(int index, FloatCollection a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        float[] b = a.toFloatArray();
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public float getFloat(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public float removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        float res = this.array[index];
        ++this.modCount;
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return res;
    }

    @Override
    public float setFloat(int index, float v) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        float res = this.array[index];
        ++this.modCount;
        this.array[index] = v;
        return res;
    }

    @Override
    public boolean addAllFloat(FloatCollection a) {
        float[] b = a.toFloatArray();
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllFloat(FloatCollection ... as) {
        int nsize = 0;
        FloatCollection[] floatCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            FloatCollection a = floatCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            int s2 = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            FloatCollection[] floatCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                FloatCollection a = floatCollectionArray2[n];
                float[] b = a.toFloatArray();
                System.arraycopy(b, 0, this.array, s2, b.length);
                s2 += a.size();
                ++n;
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllFloat(Collection<? extends FloatCollection> as) {
        int nsize = 0;
        for (FloatCollection floatCollection : as) {
            nsize += floatCollection.size();
        }
        if (nsize > 0) {
            int n = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            for (FloatCollection floatCollection : as) {
                void var3_8;
                float[] b = floatCollection.toFloatArray();
                System.arraycopy(b, 0, this.array, (int)var3_8, b.length);
                var3_8 += floatCollection.size();
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAllFloat(float[] b) {
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllFloat(int index, float[] b) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (b.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public float[] toFloatArray() {
        float[] b = new float[this.size];
        System.arraycopy(this.array, 0, b, 0, this.size);
        return b;
    }

    @Override
    public float[] toFloatArray(float[] a) {
        if (a.length < this.size) {
            return this.toFloatArray();
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = this.array.length;
    }
}

