/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.Arrays;
import net.morilib.util.primitive.AbstractFloatVector;
import net.morilib.util.primitive.FloatVector;

public class AsFloat {
    public static FloatVector valuesOf(final float ... a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new AbstractFloatVector(){

            @Override
            public int size() {
                Arrays.asList(new Object[0]);
                return a.length;
            }

            @Override
            public void addFloat(int index, float v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float getFloat(int index) {
                if (index < 0 || index >= a.length) {
                    throw new IndexOutOfBoundsException();
                }
                return a[index];
            }

            @Override
            public float removeAt(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float setFloat(int index, float v) {
                if (index < 0 || index >= a.length) {
                    throw new IndexOutOfBoundsException();
                }
                float r = a[index];
                a[index] = v;
                return r;
            }

            @Override
            public void clear() {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public float[] toFloatArray() {
                return (float[])a.clone();
            }

            @Override
            public float[] toFloatArray(float[] ar) {
                if (a.length > ar.length) {
                    return this.toFloatArray();
                }
                System.arraycopy(ar, 0, a, 0, a.length);
                return ar;
            }
        };
    }

    public static FloatVector vector(int ... a) {
        if (a == null) {
            throw new NullPointerException();
        }
        final float[] a2 = new float[a.length];
        int i = 0;
        while (i < a.length) {
            a2[i] = a[i];
            ++i;
        }
        return new AbstractFloatVector(){

            @Override
            public int size() {
                return a2.length;
            }

            @Override
            public void addFloat(int index, float v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float getFloat(int index) {
                if (index < 0 || index >= a2.length) {
                    throw new IndexOutOfBoundsException();
                }
                return a2[index];
            }

            @Override
            public float removeAt(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float setFloat(int index, float v) {
                if (index < 0 || index >= a2.length) {
                    throw new IndexOutOfBoundsException();
                }
                float r = a2[index];
                a2[index] = v;
                return r;
            }

            @Override
            public void clear() {
                throw new IndexOutOfBoundsException();
            }
        };
    }
}

