/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io.filter;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MtimeFileFilter
implements FileFilter {
    static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private String relop;
    private Date date;

    static {
        FORMAT.setLenient(false);
    }

    public MtimeFileFilter(String relop, Date date) {
        this.relop = relop;
        this.date = date;
    }

    @Override
    public boolean accept(File pathname) {
        if (this.relop.equals("<")) {
            return pathname.lastModified() < this.date.getTime();
        }
        if (this.relop.equals("<=")) {
            return pathname.lastModified() <= this.date.getTime();
        }
        if (this.relop.equals(">")) {
            return pathname.lastModified() > this.date.getTime();
        }
        if (this.relop.equals(">=")) {
            return pathname.lastModified() >= this.date.getTime();
        }
        if (this.relop.equals("=")) {
            return pathname.lastModified() == this.date.getTime();
        }
        if (this.relop.equals("!=")) {
            return pathname.lastModified() != this.date.getTime();
        }
        throw new RuntimeException();
    }

    public String toString() {
        return "mtime" + this.relop + FORMAT.format(this.date);
    }
}

